/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.schemas.utils;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Hex;

public class Utils {
    public static final Hex HEX = new Hex();

    public static byte[] md5(byte[] bytes) {
        try {
            MessageDigest digest = MessageDigest.getInstance("md5");
            return digest.digest(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("This can't happen.", e);
        }
    }

    public static byte[] utf8(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("This can't happen");
        }
    }

    public static <T> T notNull(T t) {
        if (t == null) {
            throw new IllegalArgumentException("Null value not allowed.");
        }
        return t;
    }

    public static boolean equals(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x == null) {
            return false;
        }
        if (y == null) {
            return false;
        }
        return x.equals(y);
    }

    public static List<File> toFiles(List<String> strs) {
        ArrayList<File> files = new ArrayList<File>();
        for (String s : strs) {
            files.add(new File(s));
        }
        return files;
    }

    public static byte[] getBytes(String s, String enc) {
        try {
            return s.getBytes(enc);
        }
        catch (UnsupportedEncodingException exp) {
            throw new RuntimeException(exp);
        }
    }
}

