/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.schemas.utils;

import com.linkedin.databus2.schemas.utils.Utils;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.avro.Schema;

public class SchemaHelper {
    public static boolean isArray(Schema.Field field) {
        return SchemaHelper.containsType(field, Schema.Type.ARRAY);
    }

    public static boolean isNullable(Schema.Field field) {
        return SchemaHelper.containsType(field, Schema.Type.NULL);
    }

    public static boolean isNullable(Schema fieldSchema) {
        return SchemaHelper.containsType(fieldSchema, Schema.Type.NULL);
    }

    public static Schema.Type getAnyType(Schema.Field field) {
        return SchemaHelper.unwindUnionSchema(field).getType();
    }

    public static Schema unwindUnionSchema(Schema.Field field) {
        Schema schema = field.schema();
        Schema.Type fieldType = schema.getType();
        if (fieldType == Schema.Type.UNION) {
            List unionTypes = schema.getTypes();
            for (Schema unionSubSchema : unionTypes) {
                if (unionSubSchema.getType() == Schema.Type.NULL) continue;
                return unionSubSchema;
            }
        }
        return schema;
    }

    public static boolean containsType(Schema.Field field, Schema.Type type) {
        return SchemaHelper.containsType(field.schema(), type);
    }

    public static boolean containsType(Schema schema, Schema.Type type) {
        Schema.Type fieldType = schema.getType();
        if (fieldType == type) {
            return true;
        }
        if (fieldType == Schema.Type.UNION) {
            List unionTypes = schema.getTypes();
            for (Schema unionSubSchema : unionTypes) {
                if (unionSubSchema.getType() != type) continue;
                return true;
            }
        }
        return false;
    }

    public static final String getMetaField(Schema schema, String metaFieldName) {
        String[] metaSplit;
        if (schema == null) {
            return null;
        }
        String metaValue = schema.getProp(metaFieldName);
        if (null != metaValue) {
            return metaValue;
        }
        String meta = schema.getProp("meta");
        if (meta == null) {
            return null;
        }
        for (String s : metaSplit = meta.split(";")) {
            int eqIdx = s.indexOf(61);
            if (eqIdx <= 0) continue;
            String itemKey = s.substring(0, eqIdx).trim();
            String itemValue = s.substring(eqIdx + 1).trim();
            if (null != metaValue || !metaFieldName.equals(itemKey)) continue;
            metaValue = itemValue;
        }
        return metaValue;
    }

    public static final String getMetaField(Schema.Field field, String metaFieldName) {
        String[] metaSplit;
        if (field == null) {
            return null;
        }
        String metaValue = field.getProp(metaFieldName);
        if (null != metaValue) {
            return metaValue;
        }
        String meta = field.getProp("meta");
        if (meta == null) {
            return null;
        }
        for (String s : metaSplit = meta.split(";")) {
            int eqIdx = s.indexOf(61);
            if (eqIdx <= 0) continue;
            String itemKey = s.substring(0, eqIdx).trim();
            String itemValue = s.substring(eqIdx + 1).trim();
            if (null != metaValue || !metaFieldName.equals(itemKey)) continue;
            metaValue = itemValue;
        }
        return metaValue;
    }

    public static final byte[] getSchemaId(String schema) {
        return Utils.md5(schema.getBytes(Charset.defaultCharset()));
    }

    public static List<Schema.Field> getOrderedFieldsByMetaField(Schema schema, final String metaFieldName, final Comparator<String> comparator) {
        if (null == schema) {
            return null;
        }
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>(schema.getFields());
        Collections.sort(fields, new Comparator<Schema.Field>(){

            @Override
            public int compare(Schema.Field o1, Schema.Field o2) {
                String m1 = SchemaHelper.getMetaField(o1, metaFieldName);
                String m2 = SchemaHelper.getMetaField(o2, metaFieldName);
                return comparator.compare(m1, m2);
            }
        });
        return fields;
    }
}

