/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.schemas.mbean;

import com.linkedin.databus2.schemas.VersionedSchema;
import com.linkedin.databus2.schemas.VersionedSchemaId;
import com.linkedin.databus2.schemas.VersionedSchemaSet;
import com.linkedin.databus2.schemas.mbean.VersionedSchemaSetStatusMBean;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class VersionedSchemaSetStatus
implements VersionedSchemaSetStatusMBean {
    private final VersionedSchemaSet _schemaSet;

    public VersionedSchemaSetStatus(VersionedSchemaSet schemaSet) {
        this._schemaSet = schemaSet;
    }

    @Override
    public String[] getLoadedSchemas() {
        Set<String> schemaBaseNames = this._schemaSet.getSchemaBaseNames();
        String[] results = new String[schemaBaseNames.size()];
        int idx = 0;
        for (String baseName : schemaBaseNames) {
            StringBuilder b = new StringBuilder(1000);
            b.append(baseName);
            b.append(": ");
            SortedMap<VersionedSchemaId, VersionedSchema> versions = this._schemaSet.getAllVersionsByName(baseName);
            boolean isFirst = true;
            for (Map.Entry<VersionedSchemaId, VersionedSchema> vs : versions.entrySet()) {
                if (!isFirst) {
                    b.append(", ");
                }
                isFirst = false;
                b.append(vs.getKey().getVersion());
            }
            results[idx++] = b.toString();
        }
        return results;
    }

    @Override
    public String getSchema(String baseName, short version) {
        VersionedSchema vs = this._schemaSet.getSchemaByNameVersion(baseName, version);
        return null == vs ? null : vs.getSchema().toString();
    }
}

