/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.schemas;

import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.schemas.NoSuchSchemaException;
import com.linkedin.databus2.schemas.SchemaId;
import com.linkedin.databus2.schemas.SchemaRegistryService;
import com.linkedin.databus2.schemas.VersionedSchema;
import com.linkedin.databus2.schemas.VersionedSchemaId;
import com.linkedin.databus2.schemas.VersionedSchemaSet;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public class VersionedSchemaSetBackedRegistryService
implements SchemaRegistryService {
    public static final String MODULE = VersionedSchemaSetBackedRegistryService.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    protected volatile VersionedSchemaSet _curSchemaSet = new VersionedSchemaSet();

    @Override
    public Map<Short, String> fetchAllSchemaVersionsBySourceName(String databusSourceName) throws NoSuchSchemaException, DatabusException {
        boolean isDebugEnabled = LOG.isDebugEnabled();
        HashMap<Short, String> resultMap = new HashMap<Short, String>();
        SortedMap<VersionedSchemaId, VersionedSchema> schemaMap = this._curSchemaSet.getAllVersionsByName(databusSourceName);
        if (null != schemaMap) {
            for (Map.Entry<VersionedSchemaId, VersionedSchema> e : schemaMap.entrySet()) {
                resultMap.put(e.getKey().getVersion(), e.getValue().getSchema().toString());
                if (!isDebugEnabled) continue;
                LOG.debug((Object)("fetchAllSchemaVersionsBySourceName: Source (" + databusSourceName + "). For Version (" + e.getKey().getVersion() + ") adding schema (" + e.getValue().getSchema().toString() + ") to result set."));
            }
        } else {
            LOG.warn((Object)("unknown source: " + databusSourceName));
        }
        return resultMap;
    }

    @Override
    public VersionedSchemaSet fetchAllMetadataSchemaVersions(short maxVersion) throws DatabusException {
        return null;
    }

    @Override
    public VersionedSchemaSet fetchAllMetadataSchemaVersions() throws DatabusException {
        return null;
    }

    @Override
    public String fetchLatestSchemaBySourceName(String databusSourceName) throws NoSuchSchemaException, DatabusException {
        String result;
        VersionedSchema vSchema = this._curSchemaSet.getLatestVersionByName(databusSourceName);
        String string = result = null != vSchema ? vSchema.getSchema().toString() : null;
        if (LOG.isDebugEnabled()) {
            if (null == result) {
                LOG.debug((Object)("No schema found for source " + databusSourceName));
            } else {
                LOG.debug((Object)("Schema for source " + databusSourceName + ": " + result));
            }
        }
        return result;
    }

    @Override
    public VersionedSchema fetchLatestVersionedSchemaBySourceName(String databusSourceName) throws NoSuchSchemaException, DatabusException {
        VersionedSchema vSchema = this._curSchemaSet.getLatestVersionByName(databusSourceName);
        return vSchema;
    }

    @Override
    public String fetchSchema(String schemaId) throws NoSuchSchemaException, DatabusException {
        byte[] idBytes = VersionedSchemaSetBackedRegistryService.getBytesFromHexSchemaId(schemaId);
        VersionedSchema vSchema = this._curSchemaSet.getById(new SchemaId(idBytes));
        if (null == vSchema) {
            throw new NoSuchSchemaException(schemaId);
        }
        return vSchema.getSchema().toString();
    }

    @Override
    public void registerSchema(VersionedSchema schema) throws DatabusException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Registering schema for source " + schema.getSchemaBaseName() + " v." + schema.getVersion() + ": " + schema.getSchema().toString()));
        }
        this._curSchemaSet.add(schema);
    }

    @Override
    public void dropDatabase(String dbName) throws DatabusException {
        throw new DatabusException("Unsupported method dropDatabase");
    }

    private static byte[] getBytesFromHexSchemaId(String hexSchemaId) {
        int bytesNum = hexSchemaId.length() / 2;
        byte[] result = new byte[bytesNum];
        for (int i = 0; i < bytesNum; ++i) {
            char c1 = hexSchemaId.charAt(2 * i);
            char c2 = hexSchemaId.charAt(2 * i + 1);
            int byteValue = (Character.digit(c1, 16) << 4) + Character.digit(c2, 16);
            result[i] = (byte)byteValue;
        }
        return result;
    }

    public VersionedSchemaSet getCurSchemaSet() {
        return this._curSchemaSet;
    }

    public void setCurSchemaSet(VersionedSchemaSet curSchemaSet) {
        this._curSchemaSet = curSchemaSet;
    }

    @Override
    public SchemaId fetchSchemaIdForSourceNameAndVersion(String databusSourceName, int version) throws DatabusException {
        VersionedSchema vschema = this._curSchemaSet.getSchemaByNameVersion(databusSourceName, (short)version);
        return SchemaId.createWithMd5(vschema.getSchema());
    }
}

