/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.schemas;

import com.linkedin.databus2.schemas.SchemaId;
import com.linkedin.databus2.schemas.VersionedSchema;
import com.linkedin.databus2.schemas.VersionedSchemaId;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.avro.Schema;
import org.apache.log4j.Logger;

public class VersionedSchemaSet {
    private static final int MAX_REHASH_NUM = 120;
    private final ReadWriteLock _lock;
    private final Map<SchemaId, VersionedSchema> _idToSchema;
    private final Map<String, SortedMap<VersionedSchemaId, VersionedSchema>> _nameToSchemas;
    private final Logger _log;
    private final boolean _rehash;

    public VersionedSchemaSet() {
        this(false);
    }

    public VersionedSchemaSet(boolean rehash) {
        this._rehash = rehash;
        this._log = Logger.getLogger(VersionedSchemaSet.class);
        this._lock = new ReentrantReadWriteLock(true);
        this._idToSchema = new HashMap<SchemaId, VersionedSchema>();
        this._nameToSchemas = new HashMap<String, SortedMap<VersionedSchemaId, VersionedSchema>>();
    }

    public int size() {
        int sz = 0;
        for (Map.Entry<String, SortedMap<VersionedSchemaId, VersionedSchema>> e : this._nameToSchemas.entrySet()) {
            sz += e.getValue().size();
        }
        return sz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean has(SchemaId id) {
        Lock readLock = this._lock.readLock();
        readLock.lock();
        try {
            boolean bl = this._idToSchema.containsKey(id);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionedSchema getById(SchemaId id) {
        Lock readLock = this._lock.readLock();
        readLock.lock();
        try {
            VersionedSchema versionedSchema = this._idToSchema.get(id);
            return versionedSchema;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionedSchema getLatestVersionByName(String schemaBaseName) {
        Lock readLock = this._lock.readLock();
        readLock.lock();
        try {
            SortedMap<VersionedSchemaId, VersionedSchema> versions = this._nameToSchemas.get(schemaBaseName);
            if (versions == null || versions.size() == 0) {
                VersionedSchema versionedSchema = null;
                return versionedSchema;
            }
            VersionedSchema versionedSchema = (VersionedSchema)versions.get(versions.lastKey());
            return versionedSchema;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<VersionedSchemaId, VersionedSchema> getAllVersionsByName(String schemaBaseName) {
        Lock readLock = this._lock.readLock();
        readLock.lock();
        try {
            SortedMap<VersionedSchemaId, VersionedSchema> sortedMap = this._nameToSchemas.get(schemaBaseName);
            return sortedMap;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<SchemaId, VersionedSchema> getAllVersionsWithSchemaId(String sourceName) {
        HashMap<SchemaId, VersionedSchema> schemaMap = new HashMap<SchemaId, VersionedSchema>(4);
        Lock readLock = this._lock.readLock();
        readLock.lock();
        try {
            for (SchemaId id : this._idToSchema.keySet()) {
                schemaMap.put(id, this._idToSchema.get(id));
            }
            HashMap<SchemaId, VersionedSchema> hashMap = schemaMap;
            return hashMap;
        }
        finally {
            readLock.unlock();
        }
    }

    public VersionedSchema getSchemaByNameVersion(String baseName, short version) {
        VersionedSchemaId lookupKey = new VersionedSchemaId(baseName, version);
        return this.getSchema(lookupKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionedSchema getSchema(VersionedSchemaId versionedSchemaId) {
        Lock readLock = this._lock.readLock();
        readLock.lock();
        try {
            VersionedSchema vs;
            SortedMap<VersionedSchemaId, VersionedSchema> versions = this.getAllVersionsByName(versionedSchemaId.getBaseSchemaName());
            VersionedSchema versionedSchema = vs = null != versions ? (VersionedSchema)versions.get(versionedSchemaId) : null;
            return versionedSchema;
        }
        finally {
            readLock.unlock();
        }
    }

    public boolean add(String name, short version, String schemaStr) {
        return this.add(name, version, null, schemaStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(String name, short version, SchemaId id, String schemaStr, boolean keepOrigStr) {
        Lock writeLock = this._lock.writeLock();
        writeLock.lock();
        try {
            if (null != this.getSchemaByNameVersion(name, version)) {
                boolean bl = false;
                return bl;
            }
            Schema avroSchema = Schema.parse((String)schemaStr);
            String origSchemaStr = null;
            if (keepOrigStr) {
                origSchemaStr = schemaStr;
            }
            VersionedSchema schema = new VersionedSchema(name, version, avroSchema, origSchemaStr);
            if (id == null) {
                this.addSchemaInternal(schema, SchemaId.createWithMd5(schema.getSchema()));
            } else {
                this.addSchemaInternal(schema, id);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    public boolean add(String name, short version, SchemaId id, String schemaStr) {
        return this.add(name, version, id, schemaStr, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(VersionedSchema schema) {
        Lock writeLock = this._lock.writeLock();
        writeLock.lock();
        try {
            if (null != this.getSchema(schema.getId())) {
                boolean bl = false;
                return bl;
            }
            SchemaId id = SchemaId.createWithMd5(schema.getSchema());
            this.addSchemaInternal(schema, id);
            boolean bl = true;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    private void addSchemaInternal(VersionedSchema schema, SchemaId id) {
        this.updateMd5Index(schema, id);
        SortedMap<VersionedSchemaId, VersionedSchema> versions = this._nameToSchemas.get(schema.getSchemaBaseName());
        if (versions == null) {
            versions = new TreeMap<VersionedSchemaId, VersionedSchema>(new Comparator<VersionedSchemaId>(){

                @Override
                public int compare(VersionedSchemaId s1, VersionedSchemaId s2) {
                    return s1.getVersion() - s2.getVersion();
                }
            });
            this._nameToSchemas.put(schema.getSchemaBaseName(), versions);
        }
        versions.put(schema.getId(), schema);
    }

    void updateMd5Index(VersionedSchema schema, SchemaId id) {
        if (this._rehash) {
            Schema avroSchema = schema.getSchema();
            HashSet<SchemaId> md5Ids = new HashSet<SchemaId>(120);
            md5Ids.add(id);
            int numElems = 0;
            for (int i = 0; i < 120 && numElems != md5Ids.size(); ++i) {
                this._log.info((Object)("Registering md5 " + id + " --> name=" + schema.getSchemaBaseName() + " version=" + schema.getVersion()));
                this._idToSchema.put(id, schema);
                numElems = md5Ids.size();
                avroSchema = Schema.parse((String)avroSchema.toString());
                id = SchemaId.createWithMd5(avroSchema);
                md5Ids.add(id);
            }
        } else {
            this._log.info((Object)("Registering md5 " + id + " --> name=" + schema.getSchemaBaseName() + " version=" + schema.getVersion()));
            this._idToSchema.put(id, schema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Lock readLock = this._lock.readLock();
        readLock.lock();
        try {
            StringBuilder builder = new StringBuilder("SchemaSet(");
            for (Map.Entry<String, SortedMap<VersionedSchemaId, VersionedSchema>> entry : this._nameToSchemas.entrySet()) {
                builder.append(entry.getKey());
                builder.append(" -> ");
                builder.append(entry.getValue());
                builder.append(", ");
            }
            builder.append(")");
            String string = builder.toString();
            return string;
        }
        finally {
            readLock.unlock();
        }
    }

    public Set<String> getSchemaBaseNames() {
        return this._nameToSchemas.keySet();
    }

    public void clear() {
        this._nameToSchemas.clear();
        this._idToSchema.clear();
    }

    public Map<SchemaId, VersionedSchema> getIdToSchema() {
        return this._idToSchema;
    }

    Map<String, SortedMap<VersionedSchemaId, VersionedSchema>> getNameToSchemas() {
        return this._nameToSchemas;
    }
}

