/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.schemas;

import com.linkedin.databus2.schemas.VersionedSchemaId;
import org.apache.avro.Schema;

public class VersionedSchema {
    private final Schema _schema;
    private final VersionedSchemaId _id;
    private final String _origSchemaStr;

    public VersionedSchema(VersionedSchemaId id, Schema s, String origSchemaStr) {
        this._schema = s;
        this._id = id;
        this._origSchemaStr = origSchemaStr;
    }

    public VersionedSchema(String baseName, short id, Schema s, String origSchemaStr) {
        this(new VersionedSchemaId(baseName, id), s, origSchemaStr);
    }

    public int getVersion() {
        return this._id.getVersion();
    }

    public Schema getSchema() {
        return this._schema;
    }

    public String toString() {
        return "(" + this.getSchemaBaseName() + "," + this.getVersion() + "," + this._schema + ")";
    }

    public String getSchemaBaseName() {
        return this._id.getBaseSchemaName();
    }

    public boolean equals(Object o) {
        if (null == o || !(o instanceof VersionedSchema)) {
            return false;
        }
        VersionedSchema other = (VersionedSchema)o;
        return this._id.equals(other._id);
    }

    public int hashCode() {
        return this._id.hashCode();
    }

    public VersionedSchemaId getId() {
        return this._id;
    }

    public String getOrigSchemaStr() {
        return this._origSchemaStr;
    }
}

