/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.schemas;

import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.schemas.FileSystemSchemaRegistryService;
import com.linkedin.databus2.schemas.SchemaRegistryConfigBuilder;
import com.linkedin.databus2.schemas.SchemaRegistryService;
import com.linkedin.databus2.schemas.SchemaRegistryStaticConfig;

public class StandardSchemaRegistryFactory {
    private final SchemaRegistryStaticConfig _config;
    private final SchemaRegistryConfigBuilder _configBuilder;

    public StandardSchemaRegistryFactory(SchemaRegistryStaticConfig config) {
        this._config = config;
        this._configBuilder = null;
    }

    public StandardSchemaRegistryFactory(SchemaRegistryConfigBuilder configBuilder) {
        this._config = null;
        this._configBuilder = configBuilder;
    }

    public SchemaRegistryService createSchemaRegistry() throws InvalidConfigException {
        SchemaRegistryStaticConfig conf = null != this._configBuilder ? this._configBuilder.build() : this._config;
        SchemaRegistryService result = null;
        switch (conf.getType()) {
            case EXISTING: {
                result = conf.getExistingService();
                break;
            }
            case FILE_SYSTEM: {
                result = FileSystemSchemaRegistryService.build(conf.getFileSystem());
                break;
            }
            default: {
                throw new IllegalStateException("schema registry type not supported: " + (Object)((Object)conf.getType()));
            }
        }
        return result;
    }
}

