/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.schemas;

import com.linkedin.databus.core.data_model.LogicalSource;
import com.linkedin.databus.core.util.IdNamePair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class SourceIdNameRegistry {
    public static final String MODULE = SourceIdNameRegistry.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private volatile HashMap<String, LogicalSource> _nameIndex = new HashMap();
    private volatile HashMap<Integer, LogicalSource> _idIndex = new HashMap();

    public SourceIdNameRegistry() {
    }

    public SourceIdNameRegistry(Collection<LogicalSource> initPairs) {
        this();
        this.update(initPairs);
    }

    public static SourceIdNameRegistry createFromIdNamePairs(Collection<IdNamePair> idNamePairs) {
        SourceIdNameRegistry result = new SourceIdNameRegistry();
        result.updateFromIdNamePairs(idNamePairs);
        return result;
    }

    public synchronized Integer getSourceId(String sourceName) {
        LogicalSource pair = this._nameIndex.get(sourceName);
        return null != pair ? pair.getId() : null;
    }

    public synchronized String getSourceName(Integer id) {
        LogicalSource pair = this._idIndex.get(id);
        return null != pair ? pair.getName() : null;
    }

    public synchronized LogicalSource getSource(Integer id) {
        return this._idIndex.get(id);
    }

    public synchronized LogicalSource getSource(String sourceName) {
        return this._nameIndex.get(sourceName);
    }

    public synchronized Collection<LogicalSource> getAllSources() {
        return this._idIndex.values();
    }

    public void updateFromIdNamePairs(Collection<IdNamePair> newPairs) {
        ArrayList<LogicalSource> srcCollection = new ArrayList<LogicalSource>(newPairs.size());
        for (IdNamePair pair : newPairs) {
            srcCollection.add(new LogicalSource(Integer.valueOf(pair.getId().intValue()), pair.getName()));
        }
        this.update(srcCollection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Collection<LogicalSource> newPairs) {
        SourceIdNameRegistry sourceIdNameRegistry = this;
        synchronized (sourceIdNameRegistry) {
            for (LogicalSource pair : newPairs) {
                this._nameIndex.put(pair.getName(), pair);
                this._idIndex.put(pair.getId(), pair);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Collection<LogicalSource> newPairs) {
        HashMap<String, LogicalSource> newNameIndex = new HashMap<String, LogicalSource>((int)((double)newPairs.size() * 1.3));
        HashMap<Integer, LogicalSource> newIdIndex = new HashMap<Integer, LogicalSource>((int)((double)newPairs.size() * 1.3));
        for (LogicalSource pair : newPairs) {
            newNameIndex.put(pair.getName(), pair);
            newIdIndex.put(pair.getId(), pair);
        }
        SourceIdNameRegistry sourceIdNameRegistry = this;
        synchronized (sourceIdNameRegistry) {
            this._nameIndex = newNameIndex;
            this._idIndex = newIdIndex;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("sources updated: " + this._idIndex.values()));
            }
        }
    }
}

