/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.schemas;

import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.schemas.FileSystemSchemaRegistryService;
import com.linkedin.databus2.schemas.SchemaRegistryService;
import com.linkedin.databus2.schemas.SchemaRegistryStaticConfig;

public class SchemaRegistryConfigBuilder
implements ConfigBuilder<SchemaRegistryStaticConfig> {
    private String _type = SchemaRegistryStaticConfig.RegistryType.FILE_SYSTEM.toString();
    private FileSystemSchemaRegistryService.Config _fileSystem = new FileSystemSchemaRegistryService.Config();
    private SchemaRegistryService _existingService = null;

    public SchemaRegistryStaticConfig build() throws InvalidConfigException {
        SchemaRegistryStaticConfig.RegistryType registryType = null;
        try {
            registryType = SchemaRegistryStaticConfig.RegistryType.valueOf(this._type);
        }
        catch (Exception e) {
            throw new InvalidConfigException("invalid schema registry type: " + this._type);
        }
        this._fileSystem.setEnabled(SchemaRegistryStaticConfig.RegistryType.FILE_SYSTEM == registryType);
        return new SchemaRegistryStaticConfig(registryType, this.getFileSystem().build(), this.getExistingService());
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public FileSystemSchemaRegistryService.Config getFileSystem() {
        return this._fileSystem;
    }

    public void setFileSystem(FileSystemSchemaRegistryService.Config fileSystem) {
        this._fileSystem = fileSystem;
    }

    public SchemaRegistryService getExistingService() {
        return this._existingService;
    }

    public void useExistingService(SchemaRegistryService schemaRegistryService) {
        this._existingService = schemaRegistryService;
    }
}

