/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.schemas;

import com.linkedin.databus2.schemas.utils.Utils;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.commons.codec.binary.Hex;

public class SchemaId {
    private final byte[] _idBytes;

    public SchemaId(byte[] newIdBytes) {
        Utils.notNull(newIdBytes);
        if (newIdBytes.length != 16 && newIdBytes.length != 4) {
            throw new IllegalArgumentException("schema id is of length is " + newIdBytes.length + " Expected length: " + 4 + " or " + 16);
        }
        this._idBytes = (byte[])newIdBytes.clone();
    }

    public static SchemaId createWithMd5(Schema schema) {
        return new SchemaId(Utils.md5(Utils.utf8(schema.toString(false))));
    }

    public static SchemaId createWithMd5(String schema) {
        return SchemaId.createWithMd5(Schema.parse((String)schema));
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SchemaId)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        SchemaId id = (SchemaId)obj;
        return Arrays.equals(this._idBytes, id._idBytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this._idBytes);
    }

    public String toString() {
        return Hex.encodeHexString((byte[])this._idBytes);
    }

    public byte[] getByteArray() {
        return this._idBytes;
    }
}

