/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.schemas;

import com.linkedin.databus2.schemas.FileSystemVersionedSchemaSetProvider;
import com.linkedin.databus2.schemas.VersionedSchema;
import com.linkedin.databus2.schemas.VersionedSchemaId;
import com.linkedin.databus2.schemas.VersionedSchemaSet;
import com.linkedin.databus2.schemas.VersionedSchemaSetProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class ResourceVersionedSchemaSetProvider
implements VersionedSchemaSetProvider {
    public static final String MODULE = ResourceVersionedSchemaSetProvider.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String INDEX_RESOURCE_NAME = "index.schemas_registry";
    private final ClassLoader _classLoader;

    public ResourceVersionedSchemaSetProvider(ClassLoader classLoader) {
        this._classLoader = null != classLoader ? classLoader : ClassLoader.getSystemClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VersionedSchemaSet loadSchemas() {
        VersionedSchemaSet result = new VersionedSchemaSet();
        InputStream indexIns = null;
        indexIns = this._classLoader.getResourceAsStream(INDEX_RESOURCE_NAME);
        if (null == indexIns) {
            LOG.info((Object)"resource not found: index.schemas_registry; no schemas will be loaded");
        } else {
            BufferedReader indexReader = null;
            try {
                indexReader = new BufferedReader(new InputStreamReader(indexIns, "UTF-8"));
                List<String> resourceNames = this.readIndex(indexReader);
                LOG.info((Object)("schema resources found: " + resourceNames));
                for (String resource : resourceNames) {
                    VersionedSchema schema = this.readSchemaFromResource(resource);
                    if (null == schema) continue;
                    result.add(schema);
                }
            }
            catch (IOException ioe) {
                LOG.error((Object)("i/o error: " + ioe.getMessage()), (Throwable)ioe);
            }
            finally {
                try {
                    indexIns.close();
                    if (null != indexReader) {
                        indexReader.close();
                    }
                }
                catch (IOException e1) {
                    LOG.error((Object)("cleanup failed: " + e1.getMessage()), (Throwable)e1);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VersionedSchema readSchemaFromResource(String resource) throws IOException {
        LOG.info((Object)("loading schema resource: " + resource));
        VersionedSchemaId schemaId = FileSystemVersionedSchemaSetProvider.parseSchemaVersion(resource);
        if (null == schemaId) {
            return null;
        }
        InputStream schemaInput = this._classLoader.getResourceAsStream(resource);
        try {
            VersionedSchema schema;
            String schemaJson = IOUtils.toString((InputStream)schemaInput);
            VersionedSchema versionedSchema = schema = new VersionedSchema(schemaId, Schema.parse((String)schemaJson), null);
            return versionedSchema;
        }
        finally {
            if (null != schemaInput) {
                schemaInput.close();
            }
        }
    }

    private List<String> readIndex(BufferedReader indexReader) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        String line = null;
        while (null != (line = indexReader.readLine())) {
            if (0 == (line = line.trim()).length()) continue;
            result.add(line);
        }
        return result;
    }
}

