/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.schemas;

import com.linkedin.databus2.schemas.VersionedSchema;
import com.linkedin.databus2.schemas.VersionedSchemaId;
import com.linkedin.databus2.schemas.VersionedSchemaSet;
import com.linkedin.databus2.schemas.VersionedSchemaSetProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class FileSystemVersionedSchemaSetProvider
implements VersionedSchemaSetProvider {
    public static final String MODULE = FileSystemVersionedSchemaSetProvider.class.getName();
    private static final Logger logger = Logger.getLogger((String)MODULE);
    static final String DEFAULT_SCHEMA_SUFFIX = ".avsc";
    static final Pattern FILE_NAME_PATTERN = Pattern.compile("(.*)\\.(\\d+).avsc");
    private final String schemaSuffix;
    private final File[] dirs;

    public FileSystemVersionedSchemaSetProvider(List<File> dirs) {
        this(dirs.toArray(new File[dirs.size()]));
    }

    public FileSystemVersionedSchemaSetProvider(File ... dirs) {
        this(DEFAULT_SCHEMA_SUFFIX, dirs);
    }

    public FileSystemVersionedSchemaSetProvider(String schemaSuffix, File ... dirs) {
        this.dirs = Arrays.copyOf(dirs, dirs.length);
        this.schemaSuffix = schemaSuffix;
    }

    @Override
    public VersionedSchemaSet loadSchemas() {
        try {
            VersionedSchemaSet schemas = new VersionedSchemaSet();
            for (File f : this.dirs) {
                this.loadSchemas(f, schemas);
            }
            return schemas;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSchemas(File f, VersionedSchemaSet schemas) throws IOException {
        if (!f.exists() || !f.canRead()) {
            throw new IllegalArgumentException("File does not exist or cannot be read: " + f.getAbsolutePath());
        }
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            if (files != null) {
                for (File child : files) {
                    this.loadSchemas(child, schemas);
                }
            }
        } else if (f.getName().endsWith(this.schemaSuffix)) {
            VersionedSchemaId verSchemaId = FileSystemVersionedSchemaSetProvider.parseSchemaVersion(f.getName());
            if (null != verSchemaId) {
                logger.info((Object)("Loading schema " + verSchemaId + " from file: " + f));
                FileInputStream input = new FileInputStream(f);
                try {
                    String schemaJson = IOUtils.toString((InputStream)input);
                    schemas.add(new VersionedSchema(verSchemaId, Schema.parse((String)schemaJson), null));
                }
                finally {
                    IOUtils.closeQuietly((InputStream)input);
                }
            }
        } else {
            logger.debug((Object)("Ignoring file " + f + " as it does not end with the required suffix '" + this.schemaSuffix + "'."));
        }
    }

    static VersionedSchemaId parseSchemaVersion(String fileName) throws IOException {
        Matcher matcher = FILE_NAME_PATTERN.matcher(fileName);
        if (matcher.matches()) {
            String baseName = matcher.group(1);
            short version = Short.parseShort(matcher.group(2));
            return new VersionedSchemaId(baseName, version);
        }
        logger.warn((Object)("Invalid file name: " + fileName));
        return null;
    }
}

