/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.schemas;

import com.linkedin.databus.core.DatabusRuntimeException;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.schemas.FileSystemVersionedSchemaSetProvider;
import com.linkedin.databus2.schemas.ResourceVersionedSchemaSetProvider;
import com.linkedin.databus2.schemas.VersionedSchema;
import com.linkedin.databus2.schemas.VersionedSchemaSet;
import com.linkedin.databus2.schemas.VersionedSchemaSetBackedRegistryService;
import java.io.File;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class FileSystemSchemaRegistryService
extends VersionedSchemaSetBackedRegistryService {
    public static final String MODULE = FileSystemSchemaRegistryService.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private final FileSystemVersionedSchemaSetProvider _fsSchemaSetProvider;
    private final ResourceVersionedSchemaSetProvider _resourceSchemaSetProvider;
    private final StaticConfig _config;
    private Thread _schemaSetRefreshThread;
    private final AtomicBoolean _stopRefreshThread = new AtomicBoolean();
    private long _lastRefreshTs = -1L;

    public static FileSystemSchemaRegistryService build(Config config) throws InvalidConfigException {
        return FileSystemSchemaRegistryService.build(config.build());
    }

    public static FileSystemSchemaRegistryService build(StaticConfig config) {
        FileSystemSchemaRegistryService service = new FileSystemSchemaRegistryService(config);
        service.initializeSchemaSet();
        if (0 == service.getCurSchemaSet().size()) {
            throw new DatabusRuntimeException("no schemas loaded; please check the schemas directory: " + config.getSchemaDir().getAbsolutePath());
        }
        if (config.getRefreshPeriodMs() > 0L) {
            service.startSchemasRefreshThread();
        }
        return service;
    }

    private FileSystemSchemaRegistryService(StaticConfig config) {
        this._curSchemaSet = new VersionedSchemaSet();
        this._fsSchemaSetProvider = new FileSystemVersionedSchemaSetProvider(Arrays.asList(config.getSchemaDir()));
        this._resourceSchemaSetProvider = new ResourceVersionedSchemaSetProvider(this.getClass().getClassLoader());
        this._schemaSetRefreshThread = null;
        this._config = config;
    }

    public boolean startSchemasRefreshThread() {
        if (this._config.getRefreshPeriodMs() <= 0L || null != this._schemaSetRefreshThread) {
            return false;
        }
        LOG.info((Object)"Starting schema refresh thread");
        this._stopRefreshThread.set(false);
        this._schemaSetRefreshThread = new Thread((Runnable)new SchemaSetRefreshThread(), "SchemaRefreshThread");
        this._schemaSetRefreshThread.setDaemon(true);
        this._schemaSetRefreshThread.start();
        return true;
    }

    public void stopSchemasRefreshThread() {
        if (null == this._schemaSetRefreshThread) {
            return;
        }
        LOG.info((Object)"Stopping schema refresh thread");
        this._stopRefreshThread.set(true);
        this._schemaSetRefreshThread.interrupt();
        while (this._schemaSetRefreshThread.isAlive()) {
            try {
                this._schemaSetRefreshThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void registerSchema(VersionedSchema schema) throws DatabusException {
        super.registerSchema(schema);
    }

    private void initializeSchemaSet() {
        LOG.info((Object)"initializing schema registry");
        this.refreshSchemaSet();
        if (0L > this._lastRefreshTs) {
            LOG.info((Object)"loading schemas from resources ");
            this._curSchemaSet = this._resourceSchemaSetProvider.loadSchemas();
            LOG.info((Object)"schemas from resources loaded");
        }
    }

    private void refreshSchemaSet() {
        LOG.info((Object)"refreshing schema registry");
        File schemaDir = this._config.getSchemaDir();
        if (!this._config.isFallbackToResources() && !schemaDir.exists()) {
            LOG.warn((Object)("schema dir not found:" + this._config.getSchemaDir()));
            return;
        }
        if (schemaDir.exists()) {
            this._curSchemaSet = this._fsSchemaSetProvider.loadSchemas();
            this._lastRefreshTs = System.currentTimeMillis();
        } else {
            LOG.info((Object)("skipping not existant schema directory: " + schemaDir.getAbsolutePath()));
        }
        LOG.info((Object)"schema registry refreshed");
    }

    public static class Config
    implements ConfigBuilder<StaticConfig> {
        public static final String DEFAULT_FS_SCHEMA_REGISTRY_PATH = "schemas_registry";
        public static final long DEFAULT_FS_SCHEMA_REGISTRY_REFRESH_MS = 3600000L;
        private String _schemaDir = "schemas_registry";
        private long _refreshPeriodMs = 3600000L;
        private boolean _enabled = true;
        private boolean _fallbackToResources = true;

        public String getSchemaDir() {
            return this._schemaDir;
        }

        public void setSchemaDir(String schemaDir) {
            this._schemaDir = schemaDir;
        }

        public long getRefreshPeriodMs() {
            return this._refreshPeriodMs;
        }

        public void setRefreshPeriodMs(long schemasRefreshPeriodMs) {
            this._refreshPeriodMs = schemasRefreshPeriodMs;
        }

        public StaticConfig build() throws InvalidConfigException {
            File schemaDirFile = new File(this._schemaDir);
            if (this._enabled && !this._fallbackToResources && !schemaDirFile.exists()) {
                throw new InvalidConfigException("Schemas dir not found: " + this._schemaDir);
            }
            return new StaticConfig(schemaDirFile, this._refreshPeriodMs, this._enabled, this._fallbackToResources);
        }

        public boolean isEnabled() {
            return this._enabled;
        }

        public void setEnabled(boolean enabled) {
            this._enabled = enabled;
        }

        public boolean isFallbackToResources() {
            return this._fallbackToResources;
        }

        public void setFallbackToResources(boolean fallbackToResources) {
            this._fallbackToResources = fallbackToResources;
        }
    }

    public static class StaticConfig {
        private final File _schemaDir;
        private final long _refreshPeriodMs;
        private final boolean _enabled;
        private final boolean _fallbackToResources;

        public StaticConfig(File schemaDir, long schemasRefreshPeriodMs, boolean enabled, boolean fallbackToResources) {
            this._schemaDir = schemaDir;
            this._refreshPeriodMs = schemasRefreshPeriodMs;
            this._enabled = enabled;
            this._fallbackToResources = fallbackToResources;
        }

        public File getSchemaDir() {
            return this._schemaDir;
        }

        public long getRefreshPeriodMs() {
            return this._refreshPeriodMs;
        }

        public boolean isEnabled() {
            return this._enabled;
        }

        public boolean isFallbackToResources() {
            return this._fallbackToResources;
        }
    }

    private class SchemaSetRefreshThread
    implements Runnable {
        @Override
        public void run() {
            while (!FileSystemSchemaRegistryService.this._stopRefreshThread.get()) {
                try {
                    Thread.sleep(FileSystemSchemaRegistryService.this._config.getRefreshPeriodMs());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                FileSystemSchemaRegistryService.this.refreshSchemaSet();
            }
            LOG.info((Object)"Quitting schema refresh thread");
        }
    }
}

