/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.schema.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.io.JsonEncoder;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;

public class AvroConverter {
    private final AvroFormat _inputFormat;
    private final AvroFormat _outputFormat;
    private final Schema _outputSchema;
    private final Schema _inputSchema;

    public AvroConverter(AvroFormat inputFormat, AvroFormat outputFormat, Schema inputSchema, Schema outputSchema) {
        this._inputFormat = inputFormat;
        this._outputFormat = outputFormat;
        this._inputSchema = inputSchema;
        this._outputSchema = outputSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GenericRecord> convert(InputStream in) throws IOException {
        BinaryDecoder inputDecoder = this._inputFormat == AvroFormat.BINARY ? DecoderFactory.defaultFactory().createBinaryDecoder(in, null) : (AvroFormat.JSON == this._inputFormat ? new JsonDecoder(this._inputSchema, in) : null);
        ArrayList<GenericRecord> result = new ArrayList<GenericRecord>();
        GenericDatumReader genericReader = this._inputSchema != this._outputSchema ? new GenericDatumReader(this._inputSchema, this._outputSchema) : new GenericDatumReader(this._inputSchema);
        switch (this._inputFormat) {
            case BINARY: 
            case JSON: {
                GenericRecord r = (GenericRecord)genericReader.read(null, (Decoder)inputDecoder);
                result.add(r);
                break;
            }
            case JSON_LINES: {
                InputStreamReader inReader = new InputStreamReader(in);
                try {
                    BufferedReader lineIn = new BufferedReader(inReader);
                    try {
                        String line = lineIn.readLine();
                        if (null != line) {
                            inputDecoder = new JsonDecoder(this._inputSchema, line);
                            GenericRecord r = (GenericRecord)genericReader.read(null, (Decoder)inputDecoder);
                            result.add(r);
                        }
                    }
                    finally {
                        lineIn.close();
                    }
                }
                finally {
                    inReader.close();
                }
            }
            default: {
                throw new RuntimeException("Unimplemented input format: " + (Object)((Object)this._inputFormat));
            }
        }
        return result;
    }

    public void convert(InputStream in, OutputStream out) throws IOException {
        JsonGenerator jsonGenerator = new JsonFactory().createJsonGenerator((Writer)new OutputStreamWriter(out));
        if (AvroFormat.JSON == this._outputFormat) {
            jsonGenerator.useDefaultPrettyPrinter();
        }
        List<GenericRecord> result = this.convert(in);
        BinaryEncoder outputEncoder = AvroFormat.BINARY == this._outputFormat ? new BinaryEncoder(out) : new JsonEncoder(this._outputSchema, jsonGenerator);
        GenericDatumWriter genericWriter = new GenericDatumWriter(this._outputSchema);
        for (GenericRecord r : result) {
            genericWriter.write((Object)r, (Encoder)outputEncoder);
        }
        outputEncoder.flush();
        out.flush();
    }

    public static enum AvroFormat {
        JSON,
        JSON_LINES,
        BINARY;

    }
}

