/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.schema.tools;

import com.linkedin.databus2.core.schema.tools.AvroConvertCli;
import com.linkedin.databus2.core.schema.tools.AvroConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;

public class AvroConvertMain {
    public static final String MODULE = AvroConvertMain.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);

    public static void main(String[] args) throws Exception {
        ConsoleAppender app = new ConsoleAppender((Layout)new SimpleLayout());
        Logger.getRootLogger().removeAllAppenders();
        Logger.getRootLogger().addAppender((Appender)app);
        AvroConvertCli cli = new AvroConvertCli();
        try {
            cli.parseCommandLine(args);
        }
        catch (ParseException pe) {
            System.err.println(pe.getMessage());
            cli.printUsage();
            System.exit(1);
        }
        if (!cli.hasOptions() || cli.hasHelpOption()) {
            cli.printUsage();
            System.exit(0);
        }
        int verbosity = cli.getVerbosity();
        switch (verbosity) {
            case 0: {
                Logger.getRootLogger().setLevel(Level.ERROR);
                break;
            }
            case 1: {
                Logger.getRootLogger().setLevel(Level.INFO);
                break;
            }
            case 2: {
                Logger.getRootLogger().setLevel(Level.DEBUG);
                break;
            }
            default: {
                Logger.getRootLogger().setLevel(Level.ALL);
            }
        }
        AvroConverter.AvroFormat inputFormat = cli.getInputFormat(AvroConverter.AvroFormat.JSON);
        LOG.info((Object)("Using input format: " + (Object)((Object)inputFormat)));
        AvroConverter.AvroFormat outputFormat = cli.getOutputFormat(AvroConverter.AvroFormat.JSON);
        LOG.info((Object)("Using output format: " + (Object)((Object)outputFormat)));
        String inputSchemaName = cli.getInputSchema(null);
        if (null == inputSchemaName) {
            System.err.println("Input schema expected");
            cli.printUsage();
            System.exit(4);
        }
        Schema inputSchema = null;
        try {
            inputSchema = AvroConvertMain.openSchema(inputSchemaName);
        }
        catch (IOException ioe) {
            System.err.println("Unable to open input schema: " + ioe);
            System.exit(2);
        }
        LOG.info((Object)("Using input schema:" + inputSchemaName));
        String outputSchemaName = cli.getOutputSchema(inputSchemaName);
        Schema outputSchema = null;
        try {
            outputSchema = outputSchemaName.equals(inputSchemaName) ? inputSchema : AvroConvertMain.openSchema(outputSchemaName);
        }
        catch (IOException ioe) {
            System.err.println("Unable to open output schema: " + ioe);
            System.exit(3);
        }
        LOG.info((Object)("Using output schema:" + outputSchemaName));
        String inputFileName = cli.getInputFileName("-");
        InputStream input = inputFileName.equals("-") ? System.in : new FileInputStream(inputFileName);
        LOG.info((Object)("Using input: " + inputFileName));
        String outputFileName = cli.getOutputFileName("-");
        OutputStream output = outputFileName.equals("-") ? System.out : new FileOutputStream(outputFileName);
        LOG.info((Object)("Using output: " + outputFileName));
        AvroConverter avroConverter = new AvroConverter(inputFormat, outputFormat, inputSchema, outputSchema);
        avroConverter.convert(input, output);
        if (!inputFileName.equals("-")) {
            input.close();
        }
        if (!outputFileName.equals("-")) {
            output.close();
        }
    }

    private static Schema openSchema(String schemaName) throws IOException {
        return Schema.parse((File)new File(schemaName));
    }
}

