/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.schema.tools;

import com.linkedin.databus2.core.schema.tools.AvroConvertMain;
import com.linkedin.databus2.core.schema.tools.AvroConverter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

class AvroConvertCli {
    public static final String HELP_OPT_NAME = " help";
    public static final char HELP_OPT_CHAR = 'h';
    public static final String INPUT_SCHEMA_OPT_NAME = "input_schema";
    public static final char INPUT_SCHEMA_OPT_CHAR = 'I';
    public static final String INPUT_FORMAT_OPT_NAME = "input_format";
    public static final char INPUT_FORMAT_OPT_CHAR = 'i';
    public static final String OUTPUT_SCHEMA_OPT_NAME = "output_schema";
    public static final char OUTPUT_SCHEMA_OPT_CHAR = 'O';
    public static final String OUTPUT_FORMAT_OPT_NAME = "output_format";
    public static final char OUTPUT_FORMAT_OPT_CHAR = 'o';
    public static final String INPUT_FILE_OPT_NAME = "input_file";
    public static final char INPUT_FILE_OPT_CHAR = 'f';
    public static final String OUTPUT_FILE_OPT_NAME = "output_file";
    public static final char OUTPUT_FILE_OPT_CHAR = 'F';
    public static final char VERBOSE_OPT_CHAR = 'v';
    private final Options _options = new Options();
    private CommandLine _cmdLine;

    public AvroConvertCli() {
        OptionBuilder.withLongOpt((String)HELP_OPT_NAME);
        OptionBuilder.withDescription((String)"this help screen");
        Option helpOption = OptionBuilder.create((char)'h');
        OptionBuilder.withLongOpt((String)INPUT_FORMAT_OPT_NAME);
        OptionBuilder.withDescription((String)"Input format: JSON, JSON_LINES, BINARY");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"format");
        Option inpFormatOption = OptionBuilder.create((char)'i');
        OptionBuilder.withLongOpt((String)OUTPUT_FORMAT_OPT_NAME);
        OptionBuilder.withDescription((String)"Output format: JSON, JSON_LINES, BINARY");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"format");
        Option outFormatOption = OptionBuilder.create((char)'o');
        OptionBuilder.withLongOpt((String)INPUT_SCHEMA_OPT_NAME);
        OptionBuilder.withDescription((String)"Input schema file");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        Option inpSchemaOption = OptionBuilder.create((char)'I');
        OptionBuilder.withLongOpt((String)OUTPUT_SCHEMA_OPT_NAME);
        OptionBuilder.withDescription((String)"Output schema file");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        Option outSchemaOption = OptionBuilder.create((char)'O');
        OptionBuilder.withLongOpt((String)INPUT_FILE_OPT_NAME);
        OptionBuilder.withDescription((String)"input file name or - for STDIN");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file | - ");
        Option inpFileOption = OptionBuilder.create((char)'f');
        OptionBuilder.withLongOpt((String)OUTPUT_FILE_OPT_NAME);
        OptionBuilder.withDescription((String)"output file name or - for STDOUT");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file | - ");
        Option outFileOption = OptionBuilder.create((char)'F');
        OptionBuilder.withDescription((String)"verbose; more occurrences increase verbosity");
        Option verboseOption = OptionBuilder.create((char)'v');
        this._options.addOption(helpOption);
        this._options.addOption(inpFormatOption);
        this._options.addOption(outFormatOption);
        this._options.addOption(inpSchemaOption);
        this._options.addOption(outSchemaOption);
        this._options.addOption(inpFileOption);
        this._options.addOption(outFileOption);
        this._options.addOption(verboseOption);
    }

    public void parseCommandLine(String[] args) throws ParseException {
        GnuParser cmdLineParser = new GnuParser();
        this._cmdLine = cmdLineParser.parse(this._options, args);
    }

    public void printUsage() {
        HelpFormatter help = new HelpFormatter();
        help.setWidth(100);
        help.printHelp("java " + AvroConvertMain.class.getName() + " [options]", this._options);
    }

    public boolean hasOptions() {
        return this._cmdLine.getOptions().length > 0;
    }

    public boolean hasHelpOption() {
        return this._cmdLine.hasOption('h');
    }

    public AvroConverter.AvroFormat getInputFormat(AvroConverter.AvroFormat defaultFormat) {
        String inpFormatString = this._cmdLine.getOptionValue('i', defaultFormat.toString());
        return AvroConverter.AvroFormat.valueOf(inpFormatString.toUpperCase());
    }

    public AvroConverter.AvroFormat getOutputFormat(AvroConverter.AvroFormat defaultFormat) {
        String outFormatString = this._cmdLine.getOptionValue('o', defaultFormat.toString());
        return AvroConverter.AvroFormat.valueOf(outFormatString.toUpperCase());
    }

    public String getInputSchema(String defaultValue) {
        return this._cmdLine.getOptionValue('I', defaultValue);
    }

    public String getOutputSchema(String defaultValue) {
        return this._cmdLine.getOptionValue('O', defaultValue);
    }

    public String getInputFileName(String defaultValue) {
        return this._cmdLine.getOptionValue('f', defaultValue);
    }

    public String getOutputFileName(String defaultValue) {
        return this._cmdLine.getOptionValue('F', defaultValue);
    }

    public int getVerbosity() {
        int cnt = 0;
        for (Option o : this._cmdLine.getOptions()) {
            if (!o.getOpt().equals("v")) continue;
            ++cnt;
        }
        return cnt;
    }
}

