/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class DBHelper {
    public static final String MODULE = DBHelper.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);

    public static void close(ResultSet rs, Statement stmt, Connection con) {
        DBHelper.close(rs);
        DBHelper.close(stmt);
        DBHelper.close(con);
    }

    public static void close(Connection obj) {
        if (obj != null) {
            try {
                obj.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void close(Statement obj) {
        if (obj != null) {
            try {
                obj.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void close(ResultSet obj) {
        if (obj != null) {
            try {
                obj.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void commit(Connection conn) throws SQLException {
        if (conn != null && !conn.isClosed()) {
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
        } else {
            LOG.error((Object)"Invoking a commit after the connection closed ");
        }
    }

    public static void rollback(Connection conn) throws SQLException {
        if (conn != null && !conn.isClosed()) {
            if (!conn.getAutoCommit()) {
                conn.rollback();
            }
        } else {
            LOG.error((Object)"Invoking a rollback after the connection is closed ");
        }
    }
}

