/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.relay.config;

import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.relay.config.ReplicationBitSetterStaticConfig;
import java.util.Arrays;

public class ReplicationBitSetterConfig
implements ConfigBuilder<ReplicationBitSetterStaticConfig> {
    public static final String DEFAULT_REPLICATION_BIT_SETTER_SOURCE_TYPE = ReplicationBitSetterStaticConfig.SourceType.NONE.toString();
    public static final String DEFAULT_MISSING_VALUE_BEHAVIOR = ReplicationBitSetterStaticConfig.MissingValueBehavior.STOP_WITH_ERROR.toString();
    private String _sourceType = DEFAULT_REPLICATION_BIT_SETTER_SOURCE_TYPE;
    private String _fieldName = "GG_STATUS";
    private String _remoteUpdateValueRegex = "g";
    private String _missingValueBehavior = DEFAULT_MISSING_VALUE_BEHAVIOR;

    @Override
    public ReplicationBitSetterStaticConfig build() throws InvalidConfigException {
        ReplicationBitSetterStaticConfig.SourceType type = null;
        try {
            type = ReplicationBitSetterStaticConfig.SourceType.valueOf(this._sourceType);
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidConfigException("Source Types should be one of (" + Arrays.asList(ReplicationBitSetterStaticConfig.SourceType.values()) + ") but is (" + this._sourceType + ")");
        }
        ReplicationBitSetterStaticConfig.MissingValueBehavior missingValueForDelete = null;
        try {
            missingValueForDelete = ReplicationBitSetterStaticConfig.MissingValueBehavior.valueOf(this._missingValueBehavior);
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidConfigException("Missing Value For Delete Behavior should be one of (" + Arrays.asList(ReplicationBitSetterStaticConfig.MissingValueBehavior.values()) + ") but is (" + this._missingValueBehavior + ")");
        }
        return new ReplicationBitSetterStaticConfig(type, this._fieldName, this._remoteUpdateValueRegex, missingValueForDelete);
    }

    public String getSourceType() {
        return this._sourceType;
    }

    public void setSourceType(String sourceType) {
        this._sourceType = sourceType;
    }

    public String getFieldName() {
        return this._fieldName;
    }

    public void setFieldName(String fieldName) {
        this._fieldName = fieldName;
    }

    public String getRemoteUpdateValueRegex() {
        return this._remoteUpdateValueRegex;
    }

    public void setRemoteUpdateValueRegex(String remoteUpdateValueRegex) {
        this._remoteUpdateValueRegex = remoteUpdateValueRegex;
    }

    public String getMissingValueBehavior() {
        return this._missingValueBehavior;
    }

    public void setMissingValueBehavior(String missingValueBehavior) {
        this._missingValueBehavior = missingValueBehavior;
    }
}

