/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.relay.config;

import com.linkedin.databus.core.DbusEventBuffer;
import com.linkedin.databus.core.data_model.PhysicalPartition;
import com.linkedin.databus.core.data_model.PhysicalSource;
import com.linkedin.databus.core.util.StringUtils;
import com.linkedin.databus2.core.BackoffTimerStaticConfig;
import com.linkedin.databus2.relay.config.LogicalSourceStaticConfig;
import com.linkedin.databus2.relay.config.PhysicalSourceConfig;
import com.linkedin.databus2.relay.config.ReplicationBitSetterStaticConfig;

public class PhysicalSourceStaticConfig {
    private final String _name;
    private final int _id;
    private final PhysicalPartition _partiton;
    private final String _uri;
    private final PhysicalSource _source;
    private final LogicalSourceStaticConfig[] _sources;
    private final long _slowSourceQueryThreshold;
    private final long _restartScnOffset;
    private final BackoffTimerStaticConfig _retries;
    private final String _resourceKey;
    private final String _role;
    private final DbusEventBuffer.StaticConfig _dbusEventBuffer;
    private final long _eventRatePerSec;
    private final long _maxThrottleDurationInSecs;
    private final ChunkingType _chunkingType;
    private final long _txnsPerChunk;
    private final long _scnChunkSize;
    private final long _chunkedScnThreshold;
    private final long _maxScnDelayMs;
    private final int _largestEventSizeInBytes;
    private final long _largestWindowSizeInBytes;
    private final boolean _errorOnMissingFields;
    private final String _xmlVersion;
    private final String _xmlEncoding;
    private final ReplicationBitSetterStaticConfig _replBitSetter;
    private static final PhysicalSource _defaultSource = new PhysicalSource("default_physical_source_uri");
    private static final PhysicalPartition _defaultPartition = new PhysicalPartition(PhysicalSourceConfig.DEFAULT_PHYSICAL_PARTITION, "default_partition_name");

    public static PhysicalSource getDefaultPhysicalSource() {
        return _defaultSource;
    }

    public static PhysicalPartition getDefaultPhysicalPartition() {
        return _defaultPartition;
    }

    public PhysicalSourceStaticConfig(String name, int id, String uri, String resourceKey, LogicalSourceStaticConfig[] sources, String role, long slowSourceQueryThreshold, long restartScnOffset, BackoffTimerStaticConfig errorRetries, ChunkingType chunkingType, long txnsPerChunk, long scnChunkSize, long chunkedScnThreshold, long maxScnDelayMs, long eventRatePerSec, long maxThrottleDurationInSecs, DbusEventBuffer.StaticConfig dbusEventBuffer, int largestEventSizeInBytes, long largestWindowSizeInBytes, boolean errorOnMissingFields, String xmlVersion, String xmlEncoding, ReplicationBitSetterStaticConfig replicationBitSetter) {
        this._name = name;
        this._id = id;
        this._partiton = new PhysicalPartition(id, this._name);
        this._uri = uri;
        this._source = new PhysicalSource(uri, role, resourceKey);
        this._sources = sources;
        this._slowSourceQueryThreshold = slowSourceQueryThreshold;
        this._restartScnOffset = restartScnOffset;
        this._retries = errorRetries;
        this._resourceKey = resourceKey;
        this._role = role;
        this._chunkingType = chunkingType;
        this._txnsPerChunk = txnsPerChunk;
        this._scnChunkSize = scnChunkSize;
        this._chunkedScnThreshold = chunkedScnThreshold;
        this._maxScnDelayMs = maxScnDelayMs;
        this._eventRatePerSec = eventRatePerSec;
        this._maxThrottleDurationInSecs = maxThrottleDurationInSecs;
        this._dbusEventBuffer = dbusEventBuffer;
        this._largestEventSizeInBytes = largestEventSizeInBytes;
        this._largestWindowSizeInBytes = largestWindowSizeInBytes;
        this._errorOnMissingFields = errorOnMissingFields;
        this._xmlEncoding = xmlEncoding;
        this._xmlVersion = xmlVersion;
        this._replBitSetter = replicationBitSetter;
    }

    public String getRole() {
        return this._role;
    }

    public String getResourceKey() {
        return this._resourceKey;
    }

    public String getName() {
        return this._name;
    }

    public int getId() {
        return this._id;
    }

    public PhysicalPartition getPhysicalPartition() {
        return this._partiton;
    }

    public String getUri() {
        return this._uri;
    }

    public PhysicalSource getPhysicalSource() {
        return this._source;
    }

    public LogicalSourceStaticConfig[] getSources() {
        return this._sources;
    }

    public long getSlowSourceQueryThreshold() {
        return this._slowSourceQueryThreshold;
    }

    public long getRestartScnOffset() {
        return this._restartScnOffset;
    }

    public BackoffTimerStaticConfig getRetries() {
        return this._retries;
    }

    public ChunkingType getChunkingType() {
        return this._chunkingType;
    }

    public long getTxnsPerChunk() {
        return this._txnsPerChunk;
    }

    public long getScnChunkSize() {
        return this._scnChunkSize;
    }

    public long getChunkedScnThreshold() {
        return this._chunkedScnThreshold;
    }

    public long getMaxScnDelayMs() {
        return this._maxScnDelayMs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("name=").append(this._name).append(";part=").append(this._partiton).append(";uri=").append(StringUtils.sanitizeDbUri(this._uri)).append(";role=").append(this._role).append(";rsKey=").append(this._resourceKey).append(";#src=").append(this._sources.length);
        return sb.toString();
    }

    public long getEventRatePerSec() {
        return this._eventRatePerSec;
    }

    public long getMaxThrottleDurationInSecs() {
        return this._maxThrottleDurationInSecs;
    }

    public int getLargestEventSizeInBytes() {
        return this._largestEventSizeInBytes;
    }

    public long getLargestWindowSizeInBytes() {
        return this._largestWindowSizeInBytes;
    }

    public DbusEventBuffer.StaticConfig getDbusEventBuffer() {
        return this._dbusEventBuffer;
    }

    public boolean isDbusEventBufferSet() {
        return this._dbusEventBuffer != null;
    }

    public boolean getErrorOnMissingFields() {
        return this._errorOnMissingFields;
    }

    public String getXmlVersion() {
        return this._xmlVersion;
    }

    public String getXmlEncoding() {
        return this._xmlEncoding;
    }

    public ReplicationBitSetterStaticConfig getReplBitSetter() {
        return this._replBitSetter;
    }

    public static enum ChunkingType {
        NO_CHUNKING,
        TXN_CHUNKING,
        SCN_CHUNKING;


        public boolean isChunkingEnabled() {
            return !this.equals((Object)NO_CHUNKING);
        }
    }
}

