/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.relay.config;

import com.linkedin.databus.core.DbusEventBuffer;
import com.linkedin.databus.core.data_model.LogicalSource;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.IdNamePair;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.core.BackoffTimerStaticConfigBuilder;
import com.linkedin.databus2.relay.config.LogicalSourceConfig;
import com.linkedin.databus2.relay.config.LogicalSourceStaticConfig;
import com.linkedin.databus2.relay.config.PhysicalSourceStaticConfig;
import com.linkedin.databus2.relay.config.ReplicationBitSetterConfig;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.json.JSONObject;

public class PhysicalSourceConfig
implements ConfigBuilder<PhysicalSourceStaticConfig> {
    public static final long DEFAULT_DBPOLL_INTERVAL_MILLIS = 500L;
    public static final long MAX_DBPOLL_INTERVAL_MILLIS = 300000L;
    public static final String DEFAULT_PHYSICAL_SOURCE_URI = "default_physical_source_uri";
    public static final Integer DEFAULT_PHYSICAL_PARTITION = 0;
    public static final String DEFAULT_PHYSICAL_PARTITION_NAME = "default_partition_name";
    public static final String DEFAULT_PHYSICAL_SOURCE_NAME = "default_physical_config_name";
    public static final String PHYSICAL_SOURCE_BASE_DIR = "databus.relay.base.string";
    public static final String PHYSICAL_SOURCE_BASE_DIR_DEFAULT = ".";
    public static final String DEFAULT_CHUNKING_TYPE = PhysicalSourceStaticConfig.ChunkingType.NO_CHUNKING.toString();
    public static final long DEFAULT_SCN_CHUNK_SIZE = 20000L;
    public static final long DEFAULT_TXN_CHUNK_SIZE = 20000L;
    public static final long DEFAULT_SCN_CHUNKED_THRESHOLD = 20000L;
    public static final long DEFAULT_MAX_SCN_DELAY_MS = 300000L;
    public static final int DEFAULT_LARGEST_EVENT_SIZE = 0x100000;
    public static final long DEFAULT_LARGEST_WINDOW_SIZE = 0x500000L;
    private String _name;
    private int _id = 0;
    private String _uri;
    private String _resourceKey = "";
    private String _role = "MASTER";
    private long _slowSourceQueryThreshold = 3000L;
    private long _restartScnOffset = 0L;
    private List<LogicalSourceConfig> _sources = new ArrayList<LogicalSourceConfig>();
    private BackoffTimerStaticConfigBuilder _retries = new BackoffTimerStaticConfigBuilder();
    private String _chunkingType;
    private long _txnsPerChunk;
    private long _scnChunkSize;
    private long _chunkedScnThreshold;
    private long _maxScnDelayMs;
    private DbusEventBuffer.Config _dbusEventBuffer;
    private long _eventRatePerSec;
    private long _maxThrottleDurationInSecs;
    private int _largestEventSizeInBytes;
    private long _largestWindowSizeInBytes;
    private boolean _errorOnMissingFields;
    private String _xmlVersion;
    private String _xmlEncoding;
    private ReplicationBitSetterConfig _replBitSetter;

    public PhysicalSourceConfig() {
        this._retries.setInitSleep(500L);
        this._retries.setMaxRetryNum(-1);
        this._retries.setMaxSleep(300000L);
        this._retries.setSleepIncFactor(2.0);
        this._retries.setSleepIncDelta(0L);
        this._chunkingType = DEFAULT_CHUNKING_TYPE;
        this._txnsPerChunk = 20000L;
        this._scnChunkSize = 20000L;
        this._chunkedScnThreshold = 20000L;
        this._maxScnDelayMs = 300000L;
        this._largestEventSizeInBytes = 0x100000;
        this._largestWindowSizeInBytes = 0x500000L;
        this._eventRatePerSec = 10L;
        this._maxThrottleDurationInSecs = 0L;
        this._errorOnMissingFields = true;
        this._dbusEventBuffer = null;
        this._xmlEncoding = "ISO-8859-1";
        this._replBitSetter = new ReplicationBitSetterConfig();
        this._xmlVersion = "1.0";
    }

    public PhysicalSourceConfig(String pSourceName, String pUri, int pPartionId) {
        this();
        this.setId(pPartionId);
        this.setName(pSourceName);
        this.setUri(pUri);
    }

    public PhysicalSourceConfig(Collection<IdNamePair> srcIds) {
        this();
        ArrayList<LogicalSourceConfig> newSources = new ArrayList<LogicalSourceConfig>(srcIds.size());
        for (IdNamePair p : srcIds) {
            LogicalSourceConfig source = new LogicalSourceConfig();
            source.setId(p.getId().shortValue());
            source.setName(p.getName());
            source.setPartitionFunction("DefaultPartition");
            source.setUri("defaultUri");
            newSources.add(source);
        }
        this.setSources(newSources);
        this.setName("DefaultSource");
        this.setId(DEFAULT_PHYSICAL_PARTITION);
        this.setUri(DEFAULT_PHYSICAL_SOURCE_URI);
    }

    public static PhysicalSourceConfig createFromLogicalSources(Collection<LogicalSource> srcIds) {
        PhysicalSourceConfig res = new PhysicalSourceConfig();
        ArrayList<LogicalSourceConfig> newSources = new ArrayList<LogicalSourceConfig>(srcIds.size());
        for (LogicalSource p : srcIds) {
            LogicalSourceConfig source = new LogicalSourceConfig();
            source.setId(p.getId().shortValue());
            source.setName(p.getName());
            source.setPartitionFunction("DefaultPartition");
            source.setUri("defaultUri");
            newSources.add(source);
        }
        res.setSources(newSources);
        res.setName(DEFAULT_PHYSICAL_PARTITION_NAME);
        res.setId(DEFAULT_PHYSICAL_PARTITION);
        res.setUri(DEFAULT_PHYSICAL_SOURCE_URI);
        return res;
    }

    public void checkForNulls() throws InvalidConfigException {
        if (this._name == null || this._name.length() == 0) {
            throw new InvalidConfigException("Name cannot be null or empty.");
        }
        if (this._id < 0) {
            throw new InvalidConfigException("Physical source id cannot be empty.");
        }
        if (this._uri == null || this._name.length() == 0) {
            throw new InvalidConfigException("URI cannot be null or empty.");
        }
        if (this._sources == null || this._sources.size() == 0) {
            throw new InvalidConfigException("Sources cannot be null or empty.");
        }
        for (LogicalSourceConfig source : this._sources) {
            source.checkForNulls();
        }
        if (this._slowSourceQueryThreshold < 0L) {
            this._slowSourceQueryThreshold = 0L;
        }
    }

    public String getUri() {
        return this._uri;
    }

    public void setUri(String uri) {
        this._uri = uri;
    }

    public int getId() {
        return this._id;
    }

    public void setId(int id) {
        this._id = id;
    }

    public void setRole(String role) {
        this._role = role;
    }

    public String getRole() {
        return this._role;
    }

    public void setResourceKey(String rk) {
        this._resourceKey = rk;
    }

    public String getResourceKey() {
        return this._resourceKey;
    }

    private LogicalSourceConfig addOrGetSource(int index) {
        if (index >= this._sources.size()) {
            for (int i = this._sources.size(); i <= index; ++i) {
                this._sources.add(new LogicalSourceConfig());
            }
        }
        return this._sources.get(index);
    }

    public LogicalSourceConfig getSource(int index) {
        LogicalSourceConfig result = this.addOrGetSource(index);
        return result;
    }

    public void setSource(int index, LogicalSourceConfig source) {
        this.addOrGetSource(index);
        this._sources.set(index, source);
    }

    public void addSource(LogicalSourceConfig source) {
        if (!this._sources.contains(source)) {
            this._sources.add(source);
        }
    }

    public List<LogicalSourceConfig> getSources() {
        return this._sources;
    }

    public void setSources(List<LogicalSourceConfig> newSources) {
        this._sources = newSources;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public long getSlowSourceQueryThreshold() {
        return this._slowSourceQueryThreshold;
    }

    public void setSlowSourceQueryThreshold(long slowSourceQueryThreshold) {
        this._slowSourceQueryThreshold = slowSourceQueryThreshold;
    }

    public long getRestartScnOffset() {
        return this._restartScnOffset;
    }

    public void setRestartScnOffset(long r) {
        this._restartScnOffset = r;
    }

    public int getLargestEventSizeInBytes() {
        return this._largestEventSizeInBytes;
    }

    public void setLargestEventSizeInBytes(int largestEventSizeInBytes) {
        this._largestEventSizeInBytes = largestEventSizeInBytes;
    }

    public long getLargestWindowSizeInBytes() {
        return this._largestWindowSizeInBytes;
    }

    public void setLargestWindowSizeInBytes(long largestWindowSizeInBytes) {
        this._largestWindowSizeInBytes = largestWindowSizeInBytes;
    }

    public boolean getErrorOnMissingFields() {
        return this._errorOnMissingFields;
    }

    public void setErrorOnMissingFields(boolean errorOnMissingFields) {
        this._errorOnMissingFields = errorOnMissingFields;
    }

    public String toString() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            StringWriter writer = new StringWriter();
            mapper.writeValue((Writer)writer, (Object)this);
            JSONObject jsonObj = new JSONObject(writer.toString());
            if (this._dbusEventBuffer != null) {
                ObjectMapper mapperDbus = new ObjectMapper();
                StringWriter writerDbus = new StringWriter();
                mapperDbus.writeValue((Writer)writerDbus, (Object)this._dbusEventBuffer);
                jsonObj.put("dbusEventBuffer", (Object)new JSONObject(writerDbus.toString()));
            } else {
                jsonObj.put("dbusEventBuffer", JSONObject.NULL);
            }
            return jsonObj.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return super.toString();
        }
    }

    public static PhysicalSourceConfig fromString(String str) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        PhysicalSourceConfig config = (PhysicalSourceConfig)mapper.readValue(str, PhysicalSourceConfig.class);
        return config;
    }

    public static PhysicalSourceConfig fromFile(File f) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        PhysicalSourceConfig config = (PhysicalSourceConfig)mapper.readValue(f, PhysicalSourceConfig.class);
        return config;
    }

    public Map<String, Object> toMap() throws JsonParseException, JsonMappingException, IOException {
        String str = this.toString();
        ObjectMapper mapper = new ObjectMapper();
        HashMap map = (HashMap)mapper.readValue(str, HashMap.class);
        return map;
    }

    public static PhysicalSourceConfig fromMap(Map<String, Object> map) throws JsonGenerationException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        StringWriter writer = new StringWriter();
        mapper.writeValue((Writer)writer, map);
        String str = writer.toString();
        return PhysicalSourceConfig.fromString(str);
    }

    @Override
    public PhysicalSourceStaticConfig build() throws InvalidConfigException {
        this.checkForNulls();
        if ((long)this._largestEventSizeInBytes >= this._largestWindowSizeInBytes) {
            throw new InvalidConfigException("Invalid relay config: largestEventSizeInBytes has to be lesser than largestWindowSizeInBytes: largestEventSizeInBytes=" + this._largestEventSizeInBytes + " largestWindowSizeInBytes=" + this._largestWindowSizeInBytes);
        }
        LogicalSourceStaticConfig[] sourcesStaticConfigs = new LogicalSourceStaticConfig[this._sources.size()];
        for (int i = 0; i < this._sources.size(); ++i) {
            sourcesStaticConfigs[i] = this._sources.get(i).build();
        }
        PhysicalSourceStaticConfig.ChunkingType chunkingType = PhysicalSourceStaticConfig.ChunkingType.valueOf(this._chunkingType);
        return new PhysicalSourceStaticConfig(this._name, this._id, this._uri, this._resourceKey, sourcesStaticConfigs, this._role, this._slowSourceQueryThreshold, this._restartScnOffset, this._retries.build(), chunkingType, this._txnsPerChunk, this._scnChunkSize, this._chunkedScnThreshold, this._maxScnDelayMs, this._eventRatePerSec, this._maxThrottleDurationInSecs, this.isDbusEventBufferSet() ? this._dbusEventBuffer.build() : null, this._largestEventSizeInBytes, this._largestWindowSizeInBytes, this._errorOnMissingFields, this._xmlVersion, this._xmlEncoding, this._replBitSetter.build());
    }

    public BackoffTimerStaticConfigBuilder getRetries() {
        return this._retries;
    }

    public void setRetries(BackoffTimerStaticConfigBuilder retries) {
        this._retries = retries;
    }

    public String getChunkingType() {
        return this._chunkingType;
    }

    public void setChunkingType(String chunkingType) {
        this._chunkingType = chunkingType;
    }

    public long getTxnsPerChunk() {
        return this._txnsPerChunk;
    }

    public void setTxnsPerChunk(long txnsPerChunk) {
        this._txnsPerChunk = txnsPerChunk;
    }

    public long getScnChunkSize() {
        return this._scnChunkSize;
    }

    public void setScnChunkSize(long scnChunkSize) {
        this._scnChunkSize = scnChunkSize;
    }

    public long getChunkedScnThreshold() {
        return this._chunkedScnThreshold;
    }

    public void setChunkedScnThreshold(long chunkedScnThreshold) {
        this._chunkedScnThreshold = chunkedScnThreshold;
    }

    public long getMaxScnDelayMs() {
        return this._maxScnDelayMs;
    }

    public void setMaxScnDelayMs(long maxScnDelayMs) {
        this._maxScnDelayMs = maxScnDelayMs;
    }

    public long getEventRatePerSec() {
        return this._eventRatePerSec;
    }

    public void setEventRatePerSec(long eventRatePerSec) {
        this._eventRatePerSec = eventRatePerSec;
    }

    public long getMaxThrottleDurationInSecs() {
        return this._maxThrottleDurationInSecs;
    }

    public void setMaxThrottleDurationInSecs(long maxThrottleDurationInSecs) {
        this._maxThrottleDurationInSecs = maxThrottleDurationInSecs;
    }

    @JsonIgnore
    public DbusEventBuffer.Config getDbusEventBuffer() {
        if (this._dbusEventBuffer == null) {
            this._dbusEventBuffer = new DbusEventBuffer.Config();
        }
        return this._dbusEventBuffer;
    }

    public void setDbusEventBuffer(DbusEventBuffer.Config _dbusEventBuffer) {
        this._dbusEventBuffer = _dbusEventBuffer;
    }

    @JsonIgnore
    public boolean isDbusEventBufferSet() {
        return this._dbusEventBuffer != null;
    }

    public String getXmlVersion() {
        return this._xmlVersion;
    }

    public void setXmlVersion(String xmlVersion) {
        this._xmlVersion = xmlVersion;
    }

    public String getXmlEncoding() {
        return this._xmlEncoding;
    }

    public void setXmlEncoding(String xmlEncoding) {
        this._xmlEncoding = xmlEncoding;
    }

    public ReplicationBitSetterConfig getReplBitSetter() {
        return this._replBitSetter;
    }

    public void setReplBitSetter(ReplicationBitSetterConfig replBitSetter) {
        this._replBitSetter = replBitSetter;
    }
}

