/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.relay.config;

import com.linkedin.databus.core.data_model.LogicalPartition;
import com.linkedin.databus.core.data_model.LogicalSource;
import com.linkedin.databus2.relay.config.LogicalSourceConfig;

public class LogicalSourceStaticConfig {
    private final short _id;
    private final String _name;
    private final String _uri;
    private final String _partitionFunction;
    private final LogicalSource _source;
    private final LogicalPartition _partition;
    private final boolean _skipInfinityScn;
    private final String _regularQueryHints;
    private final String _chunkedTxnQueryHints;
    private final String _chunkedScnQueryHints;
    private static final LogicalPartition _defaultPartition = new LogicalPartition(LogicalSourceConfig.DEFAULT_LOGICAL_SOURCE_PARTITION);

    public static LogicalPartition getDefaultLogicalSourcePartition() {
        return _defaultPartition;
    }

    public LogicalSourceStaticConfig(short id, String name, String uri, String partitionFunction, short partition, boolean skipInfinityScn, String regularQueryHints, String chunkedTxnQueryHints, String chunkedScnQueryHints) {
        this._id = id;
        this._name = name;
        this._uri = uri;
        this._partitionFunction = partitionFunction;
        this._source = new LogicalSource(Integer.valueOf(this._id), this._name);
        this._partition = new LogicalPartition(partition);
        this._skipInfinityScn = skipInfinityScn;
        this._regularQueryHints = regularQueryHints;
        this._chunkedTxnQueryHints = chunkedTxnQueryHints;
        this._chunkedScnQueryHints = chunkedScnQueryHints;
    }

    public short getId() {
        return this._id;
    }

    public LogicalSource getLogicalSource() {
        return this._source;
    }

    public String getName() {
        return this._name;
    }

    public String getUri() {
        return this._uri;
    }

    public String getPartitionFunction() {
        return this._partitionFunction;
    }

    public LogicalPartition getPartition() {
        return this._partition;
    }

    public boolean isSkipInfinityScn() {
        return this._skipInfinityScn;
    }

    public String getRegularQueryHints() {
        return this._regularQueryHints;
    }

    public String getChunkedTxnQueryHints() {
        return this._chunkedTxnQueryHints;
    }

    public String getChunkedScnQueryHints() {
        return this._chunkedScnQueryHints;
    }
}

