/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.relay.config;

import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.relay.config.LogicalSourceStaticConfig;

public class LogicalSourceConfig
implements ConfigBuilder<LogicalSourceStaticConfig> {
    public static final Short DEFAULT_LOGICAL_SOURCE_PARTITION = 0;
    public static final String DEFAULT_SCN_CHUNKING_HINTS = "/*+ first_rows LEADING(tx) */";
    public static final String DEFAULT_ROW_CHUNKING_HINTS = "/*+ first_rows LEADING(tx) cardinality(tx,1) */";
    public static final String DEFAULT_EVENT_QUERY_HINTS = "/*+ first_rows LEADING(tx) */";
    private short _id = (short)-1;
    private String _name;
    private String _uri;
    private String _partitionFunction;
    private short _partition;
    private boolean _skipInfinityScn = false;
    private String _regularQueryHints = "/*+ first_rows LEADING(tx) */";
    private String _chunkedTxnQueryHints = "/*+ first_rows LEADING(tx) cardinality(tx,1) */";
    private String _chunkedScnQueryHints = "/*+ first_rows LEADING(tx) */";

    public void checkForNulls() throws InvalidConfigException {
        if (this._id < 0) {
            throw new InvalidConfigException("ID cannot be null. Must be >= 0.");
        }
        if (this._name == null || this._name.length() == 0) {
            throw new InvalidConfigException("Name cannot be null or empty.");
        }
        if (this._uri == null || this._uri.length() == 0) {
            throw new InvalidConfigException("Schema cannot be null or empty.");
        }
        if (this._partitionFunction == null || this._partitionFunction.length() == 0) {
            throw new InvalidConfigException("PartitionFunction cannot be null or empty.");
        }
    }

    public short getId() {
        return this._id;
    }

    public void setId(short id) {
        this._id = id;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getPartitionFunction() {
        return this._partitionFunction;
    }

    public void setPartitionFunction(String partitionFunction) {
        this._partitionFunction = partitionFunction;
    }

    public String getUri() {
        return this._uri;
    }

    public void setUri(String uri) {
        this._uri = uri;
    }

    public void setPartition(short partition) {
        this._partition = partition;
    }

    public short getPartition() {
        return this._partition;
    }

    @Override
    public LogicalSourceStaticConfig build() throws InvalidConfigException {
        this.checkForNulls();
        return new LogicalSourceStaticConfig(this._id, this._name, this._uri, this._partitionFunction, this._partition, this._skipInfinityScn, this._regularQueryHints, this._chunkedTxnQueryHints, this._chunkedScnQueryHints);
    }

    public boolean isSkipInfinityScn() {
        return this._skipInfinityScn;
    }

    public void setSkipInfinityScn(boolean skipInfScn) {
        this._skipInfinityScn = skipInfScn;
    }

    public String getRegularQueryHints() {
        return this._regularQueryHints;
    }

    public void setRegularQueryHints(String regularQueryHints) {
        this._regularQueryHints = regularQueryHints;
    }

    public String getChunkedTxnQueryHints() {
        return this._chunkedTxnQueryHints;
    }

    public void setChunkedTxnQueryHints(String chunkedTxnQueryHints) {
        this._chunkedTxnQueryHints = chunkedTxnQueryHints;
    }

    public String getChunkedScnQueryHints() {
        return this._chunkedScnQueryHints;
    }

    public void setChunkedScnQueryHints(String chunkedScnQueryHints) {
        this._chunkedScnQueryHints = chunkedScnQueryHints;
    }
}

