/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.relay.config;

import com.linkedin.databus2.relay.config.DatabusRelaySources;
import com.linkedin.databus2.relay.config.PhysicalSourceConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DatabusRelaySourcesInFiles
implements DatabusRelaySources {
    protected static final Logger LOG = Logger.getLogger((String)DatabusRelaySourcesInFiles.class.getName());
    final HashMap<String, PhysicalSourceConfig> _configs;
    private final String _dir;

    public DatabusRelaySourcesInFiles(String sourceDir) throws Exception {
        File dir = new File(sourceDir);
        if (!dir.isDirectory()) {
            throw new IOException("Source directory error: path=  " + sourceDir + " exists=" + dir.exists() + " isDirectory=" + dir.isDirectory());
        }
        this._dir = sourceDir;
        this._configs = new HashMap();
    }

    protected File[] getFiles() {
        File dir = new File(this._dir);
        File[] listFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".json") || name.endsWith(".JSON");
            }
        });
        return listFiles;
    }

    protected ArrayList<PhysicalSourceConfig> getConfigs() {
        File[] listFiles = this.getFiles();
        ArrayList<PhysicalSourceConfig> configs = new ArrayList<PhysicalSourceConfig>();
        for (File f : listFiles) {
            try {
                PhysicalSourceConfig pConfig = PhysicalSourceConfig.fromFile(f);
                if (pConfig != null) {
                    configs.add(pConfig);
                    continue;
                }
                LOG.warn((Object)("Unable to deserialize " + f.getAbsolutePath() + " Skipping!"));
            }
            catch (Exception e) {
                LOG.warn((Object)("Skipping file: " + f.getAbsolutePath() + " Exception: " + e.getMessage()));
            }
        }
        return configs;
    }

    @Override
    public boolean add(String sourceName, PhysicalSourceConfig config) {
        if (!this._configs.containsKey(sourceName)) {
            this._configs.put(sourceName, config);
            return true;
        }
        LOG.warn((Object)("Source " + sourceName + " already exists! Not adding config. Please remove entry using remove()"));
        return false;
    }

    @Override
    public PhysicalSourceConfig get(String sourceName) {
        return this._configs.get(sourceName);
    }

    protected void clear() {
        this._configs.clear();
    }

    public void removePersistedEntries() {
        File[] files;
        for (File f : files = this.getFiles()) {
            f.delete();
        }
    }

    @Override
    public boolean save() {
        boolean ret = true;
        for (Map.Entry<String, PhysicalSourceConfig> entry : this._configs.entrySet()) {
            String fileName = "sources-" + entry.getKey() + ".json";
            String filePath = this._dir + "/" + fileName;
            if (entry.getValue() == null) {
                LOG.warn((Object)("Sourcename " + entry.getKey() + " has null value. Not persisting."));
                continue;
            }
            try {
                FileOutputStream file = new FileOutputStream(filePath, false);
                String val = entry.getValue().toString();
                file.write(val.getBytes(Charset.defaultCharset()));
                file.close();
            }
            catch (Exception e) {
                LOG.warn((Object)("Cannot save " + filePath + " for source " + entry.getKey()));
                ret = false;
            }
        }
        return ret;
    }

    @Override
    public boolean load() {
        this.clear();
        ArrayList<PhysicalSourceConfig> configs = this.getConfigs();
        for (PhysicalSourceConfig conf : configs) {
            this.add(conf.getName(), conf);
        }
        return true;
    }

    @Override
    public boolean removeAll() {
        this.clear();
        return true;
    }

    @Override
    public PhysicalSourceConfig[] getAll() {
        PhysicalSourceConfig[] pConfigs = new PhysicalSourceConfig[this._configs.size()];
        int i = 0;
        for (Object o : this._configs.values().toArray()) {
            pConfigs[i++] = (PhysicalSourceConfig)o;
        }
        return pConfigs;
    }

    @Override
    public boolean remove(String sourceName) {
        if (this._configs.containsKey(sourceName)) {
            this._configs.remove(sourceName);
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this._configs.size();
    }
}

