/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.seq;

import com.linkedin.databus.core.NamedObject;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.core.seq.MaxSCNReaderWriter;
import com.linkedin.databus2.core.seq.SequenceNumberHandlerFactory;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class MultiServerSequenceNumberHandler {
    public static final String MODULE = MultiServerSequenceNumberHandler.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private final SequenceNumberHandlerFactory _handlerFactory;
    private final Map<NamedObject, MaxSCNReaderWriter> _handlers;

    public MultiServerSequenceNumberHandler(SequenceNumberHandlerFactory handlerFactory) {
        this._handlerFactory = handlerFactory;
        this._handlers = new Hashtable<NamedObject, MaxSCNReaderWriter>(4);
    }

    public MaxSCNReaderWriter getHandler(NamedObject serverName) {
        return this._handlers.get(serverName);
    }

    public MaxSCNReaderWriter getOrCreateHandler(NamedObject serverName) throws DatabusException {
        MaxSCNReaderWriter handler = this.getHandler(serverName);
        if (null == handler) {
            LOG.info((Object)("creating sequence number handler for server name:" + serverName));
            handler = this._handlerFactory.createHandler(serverName.getName());
            this._handlers.put(serverName, handler);
        }
        return handler;
    }

    public long readLastSequenceNumber(NamedObject serverName) {
        try {
            MaxSCNReaderWriter handler = this.getOrCreateHandler(serverName);
            return handler.getMaxScn();
        }
        catch (DatabusException de) {
            LOG.error((Object)("error obtaining sequence number for serverName " + serverName + ": " + de.getMessage()), (Throwable)de);
            return -1L;
        }
    }

    public void writeLastSequenceNumber(NamedObject serverName, long seq) throws DatabusException {
        MaxSCNReaderWriter handler = this.getOrCreateHandler(serverName);
        handler.saveMaxScn(seq);
    }
}

