/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.seq;

import com.linkedin.databus2.core.seq.FileMaxSCNHandler;
import com.linkedin.databus2.core.seq.FileMaxSCNHandlerFactory;
import com.linkedin.databus2.core.seq.InMemorySequenceNumberHandler;
import com.linkedin.databus2.core.seq.InMemorySequenceNumberHandlerFactory;
import com.linkedin.databus2.core.seq.MaxSCNReaderWriter;
import com.linkedin.databus2.core.seq.SequenceNumberHandlerFactory;
import org.apache.log4j.Logger;

public class MaxSCNReaderWriterStaticConfig {
    public static final String MODULE = MaxSCNReaderWriterStaticConfig.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private final Type _type;
    private final FileMaxSCNHandler.StaticConfig _file;
    private final MaxSCNReaderWriter _existing;

    public MaxSCNReaderWriterStaticConfig(Type type, FileMaxSCNHandler.StaticConfig file, MaxSCNReaderWriter existing) {
        this._type = type;
        this._file = file;
        this._existing = existing;
    }

    public Type getType() {
        return this._type;
    }

    public FileMaxSCNHandler.StaticConfig getFile() {
        return this._file;
    }

    public MaxSCNReaderWriter obtainExisting() {
        return this._existing;
    }

    public MaxSCNReaderWriter createOrUseExisting() {
        MaxSCNReaderWriter result = null;
        switch (this._type) {
            case FILE: {
                try {
                    result = FileMaxSCNHandler.create(this._file);
                }
                catch (Exception e) {
                    LOG.error((Object)("Unable to create FileMaxSCNHandler:" + e.getMessage()), (Throwable)e);
                }
                break;
            }
            case IN_MEMORY: {
                result = new InMemorySequenceNumberHandler();
                break;
            }
            case EXISTING: {
                result = this._existing;
                break;
            }
            case DISABLED: {
                result = null;
                break;
            }
            default: {
                throw new RuntimeException("unknown scn reader/writer type: " + this._type.toString());
            }
        }
        return result;
    }

    public SequenceNumberHandlerFactory createFactory() {
        SequenceNumberHandlerFactory result = null;
        switch (this._type) {
            case FILE: {
                try {
                    FileMaxSCNHandler.Config configBuilder = new FileMaxSCNHandler.Config();
                    configBuilder.setFlushItvl(this._file.getFlushItvl());
                    configBuilder.setInitVal(this._file.getInitVal());
                    configBuilder.setKey(this._file.getKey());
                    configBuilder.setScnDir(this._file.getScnDir().getAbsolutePath());
                    result = new FileMaxSCNHandlerFactory(configBuilder);
                }
                catch (Exception e) {
                    LOG.error((Object)("Unable to create FileMaxSCNHandler:" + e.getMessage()), (Throwable)e);
                }
                break;
            }
            case IN_MEMORY: {
                result = new InMemorySequenceNumberHandlerFactory(-1L);
                break;
            }
            case DISABLED: {
                result = null;
                break;
            }
            default: {
                throw new RuntimeException("unknown scn reader/writer type: " + this._type.toString());
            }
        }
        return result;
    }

    public static enum Type {
        DISABLED,
        FILE,
        EXISTING,
        IN_MEMORY;

    }
}

