/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.seq;

import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.core.seq.FileMaxSCNHandler;
import com.linkedin.databus2.core.seq.MaxSCNReaderWriter;
import com.linkedin.databus2.core.seq.MaxSCNReaderWriterStaticConfig;

public class MaxSCNReaderWriterConfig
implements ConfigBuilder<MaxSCNReaderWriterStaticConfig> {
    private String _type = MaxSCNReaderWriterStaticConfig.Type.FILE.toString();
    private FileMaxSCNHandler.Config _file = new FileMaxSCNHandler.Config();
    private MaxSCNReaderWriter _existing = null;

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public FileMaxSCNHandler.Config getFile() {
        return this._file;
    }

    public void setFile(FileMaxSCNHandler.Config file) {
        this._file = file;
    }

    public MaxSCNReaderWriter fixmeGetExisting() {
        return this._existing;
    }

    public void fixmeSetExisting(MaxSCNReaderWriter existing) {
        this._existing = existing;
    }

    @Override
    public MaxSCNReaderWriterStaticConfig build() throws InvalidConfigException {
        MaxSCNReaderWriterStaticConfig.Type handlerType = null;
        try {
            handlerType = MaxSCNReaderWriterStaticConfig.Type.valueOf(this._type);
        }
        catch (Exception e) {
            throw new InvalidConfigException("invalid max scn reader/writer type:" + this._type);
        }
        if (MaxSCNReaderWriterStaticConfig.Type.EXISTING == handlerType && null == this._existing) {
            throw new InvalidConfigException("No existing max scn reader/writer specified ");
        }
        return new MaxSCNReaderWriterStaticConfig(handlerType, this._file.build(), this._existing);
    }
}

