/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.seq;

import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.core.seq.FileMaxSCNHandler;
import com.linkedin.databus2.core.seq.MaxSCNReaderWriter;
import com.linkedin.databus2.core.seq.SequenceNumberHandlerFactory;
import java.io.IOException;

public class FileMaxSCNHandlerFactory
implements SequenceNumberHandlerFactory {
    private final FileMaxSCNHandler.Config _configBuilder;

    public FileMaxSCNHandlerFactory(FileMaxSCNHandler.Config configBuilder) {
        this._configBuilder = configBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MaxSCNReaderWriter createHandler(String id) throws DatabusException {
        FileMaxSCNHandler result;
        FileMaxSCNHandler.Config config = this._configBuilder;
        synchronized (config) {
            FileMaxSCNHandler.StaticConfig config2;
            String saveKey = this._configBuilder.getKey();
            this._configBuilder.setKey(saveKey + "_" + id);
            try {
                config2 = this._configBuilder.build();
            }
            catch (InvalidConfigException ice) {
                throw new DatabusException("unable to create sequence number handler: " + ice.getMessage(), ice);
            }
            try {
                result = FileMaxSCNHandler.create(config2);
            }
            catch (IOException ioe) {
                throw new DatabusException("unable to create sequence number handler: " + ioe.getMessage(), ioe);
            }
            this._configBuilder.setKey(saveKey);
        }
        return result;
    }
}

