/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.seq;

import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.core.seq.MaxSCNReaderWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public class FileMaxSCNHandler
implements MaxSCNReaderWriter {
    private static final String TEMP = ".temp";
    public static final String SCN_SEPARATOR = ":";
    private static final String MODULE = FileMaxSCNHandler.class.getName();
    private static final Logger LOG = Logger.getLogger((String)MODULE);
    private final String _scnFileName;
    private final AtomicLong _scn;
    private final AtomicLong _flushCounter;
    private final StaticConfig _staticConfig;

    public static FileMaxSCNHandler create(Config config) throws IOException, DatabusException, InvalidConfigException {
        return FileMaxSCNHandler.create(config.build());
    }

    public static FileMaxSCNHandler create(StaticConfig config) throws IOException, DatabusException {
        FileMaxSCNHandler hdlr = new FileMaxSCNHandler(config);
        hdlr.loadInitialValue();
        return hdlr;
    }

    public FileMaxSCNHandler(StaticConfig config) {
        this._staticConfig = config;
        this._flushCounter = new AtomicLong(0L);
        this._scn = new AtomicLong(0L);
        this._scnFileName = this._staticConfig.getScnDir().getAbsolutePath() + File.separator + this._staticConfig.getKey();
        LOG.info((Object)("creating file:" + this._scnFileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadInitialValue() throws IOException, DatabusException {
        Object initVal = null;
        LOG.info((Object)("Trying to read initial SCN from file: " + this._scnFileName));
        File file = new File(this._scnFileName);
        if (file.exists()) {
            FileReader fileReader = new FileReader(file);
            try {
                BufferedReader reader = new BufferedReader(fileReader);
                String scnLine = reader.readLine();
                if (null != scnLine) {
                    try {
                        String scnString = scnLine.substring(0, scnLine.indexOf(SCN_SEPARATOR));
                        this._scn.set(Long.parseLong(scnString));
                        LOG.info((Object)("Starting from MAX SCN:" + scnString));
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Could not read initial SCN value. Value missing or not in expected format; scnLine = " + scnLine), (Throwable)e);
                        throw new DatabusException("Failed to load initial SCN value. Value misisng or not in expected format.", e);
                    }
                } else {
                    LOG.warn((Object)("SCN file empty; defaulting to initial value from configuration:" + this._staticConfig.getInitVal()));
                    this._scn.set(this._staticConfig.getInitVal());
                }
                reader.close();
            }
            finally {
                fileReader.close();
            }
        } else {
            LOG.info((Object)("Initial max SCN does not exist. Defaulting to initial value from configuration: " + this._staticConfig.getInitVal()));
            this._scn.set(this._staticConfig.getInitVal());
            this.writeScnToFile();
        }
    }

    private void writeScnToFile() throws IOException {
        File scnFile;
        long scn = this._scn.longValue();
        File dir = this._staticConfig.getScnDir();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("unable to create SCN file parent:" + dir.getAbsolutePath());
        }
        File tempScnFile = new File(this._scnFileName + TEMP);
        if (tempScnFile.exists() && !tempScnFile.delete()) {
            LOG.error((Object)("unable to erase temp SCN file: " + tempScnFile.getAbsolutePath()));
        }
        if ((scnFile = new File(this._scnFileName)).exists() && !scnFile.renameTo(tempScnFile)) {
            LOG.error((Object)"unable to backup scn file");
        }
        if (!scnFile.createNewFile()) {
            LOG.error((Object)("unable to create new SCN file:" + scnFile.getAbsolutePath()));
        }
        FileWriter writer = new FileWriter(scnFile);
        writer.write(Long.toString(scn));
        writer.write(SCN_SEPARATOR + new Date().toString());
        writer.flush();
        writer.close();
        LOG.debug((Object)("scn persisted: " + scn));
    }

    @Override
    public long getMaxScn() {
        return this._scn.get();
    }

    @Override
    public void saveMaxScn(long endOfPeriod) throws DatabusException {
        this._scn.set(endOfPeriod);
        long ctr = this._flushCounter.addAndGet(1L);
        if (ctr % this._staticConfig.getFlushItvl() == 0L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Flushing counter:" + ctr));
            }
            try {
                this.writeScnToFile();
            }
            catch (IOException e) {
                LOG.error((Object)("Caught exception saving SCN = " + this._scn), (Throwable)e);
                throw new DatabusException("Caught exception saving SCN = " + this._scn, e);
            }
        }
    }

    public void destroy() {
        LOG.info((Object)"destory() called, saving scn file before shutting down.");
        try {
            this.writeScnToFile();
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to write final SCN value to file on destroy()", (Throwable)e);
        }
    }

    public String toString() {
        return this._scnFileName + SCN_SEPARATOR + this._scn;
    }

    public static class Config
    implements ConfigBuilder<StaticConfig> {
        private String _key = "MaxSCN";
        private String _scnDir = "databus2-maxscn";
        private Long _initVal = 0L;
        private Long _flushItvl = 1L;

        public String getKey() {
            return this._key;
        }

        public void setKey(String key) {
            this._key = key;
        }

        public void setScnDir(String scnDir) {
            this._scnDir = scnDir;
        }

        public String getScnDir() {
            return this._scnDir;
        }

        public void setInitVal(long scn) {
            this._initVal = scn;
        }

        public long getInitVal() {
            return this._initVal;
        }

        public void setFlushItvl(Long flushItvl) {
            this._flushItvl = flushItvl;
        }

        public Long getFlushItvl() {
            return this._flushItvl;
        }

        @Override
        public StaticConfig build() throws InvalidConfigException {
            File scnDir = new File(this._scnDir);
            if (!scnDir.exists() && !scnDir.mkdirs()) {
                throw new InvalidConfigException("Unable to create scn dir:" + this._scnDir);
            }
            if (!scnDir.isDirectory()) {
                throw new InvalidConfigException("Not an scn dir:" + this._scnDir);
            }
            if (this._flushItvl <= 0L) {
                throw new InvalidConfigException("Invalid flush interval:" + this._flushItvl);
            }
            return new StaticConfig(this._key, scnDir, this._initVal, this._flushItvl);
        }
    }

    public static class StaticConfig {
        private final String _key;
        private final File _scnDir;
        private final Long _initVal;
        private final Long _flushItvl;

        public StaticConfig(String key, File scnDir, Long initVal, Long flushItvl) {
            this._key = key;
            this._scnDir = scnDir;
            this._initVal = initVal;
            this._flushItvl = flushItvl;
        }

        public String getKey() {
            return this._key;
        }

        public File getScnDir() {
            return this._scnDir;
        }

        public Long getInitVal() {
            return this._initVal;
        }

        public Long getFlushItvl() {
            return this._flushItvl;
        }
    }
}

