/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.mbean;

import com.linkedin.databus.core.DatabusComponentStatus;
import com.linkedin.databus2.core.mbean.BaseDatabusMBean;
import com.linkedin.databus2.core.mbean.DatabusReadOnlyStatusMBean;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class DatabusReadOnlyStatus
extends BaseDatabusMBean
implements DatabusReadOnlyStatusMBean {
    private final DatabusComponentStatus _status;
    private final String _name;
    private final long _ownerId;

    public DatabusReadOnlyStatus(String name, DatabusComponentStatus status, long ownerId) {
        this._status = status;
        this._name = name;
        this._ownerId = ownerId;
    }

    @Override
    public String getStatus() {
        return this._status.getStatus().toString();
    }

    @Override
    public String getStatusMessage() {
        return this._status.getMessage();
    }

    @Override
    public String getComponentName() {
        return this._name;
    }

    @Override
    public int getStatusCode() {
        return this._status.getStatus().getCode();
    }

    @Override
    public ObjectName generateObjectName() throws MalformedObjectNameException {
        Hashtable<String, String> nameProps = this.generateBaseMBeanProps();
        nameProps.put("name", this.sanitizeString(this._name));
        nameProps.put("ownerId", Long.toString(this._ownerId));
        return new ObjectName("com.linkedin.databus2", nameProps);
    }

    @Override
    public int getRetriesNum() {
        return this._status.getRetriesNum();
    }

    @Override
    public int getRemainingRetriesNum() {
        return this._status.getRetriesLeft();
    }

    @Override
    public long getCurrentRetryLatency() {
        return this._status.getLastRetrySleepMs();
    }

    @Override
    public long getTotalRetryTime() {
        return this._status.getRetriesCounter().getTotalRetryTime();
    }

    private String sanitizeString(String s) {
        return s.replaceAll("[.,;]", "_");
    }

    @Override
    public long getUptimeMs() {
        return this._status.getUptimeMs();
    }
}

