/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.mbean;

import com.linkedin.databus.core.util.JmxUtil;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public abstract class BaseDatabusMBean {
    public static final String MODULE = BaseDatabusMBean.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String JMX_DOMAIN = "com.linkedin.databus2";

    public boolean registerAsMbean(MBeanServer mbeanServer) {
        boolean success = false;
        if (null != mbeanServer) {
            try {
                ObjectName objName = this.generateObjectName();
                if (mbeanServer.isRegistered(objName)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("unregistering old MBean: " + objName));
                    }
                    mbeanServer.unregisterMBean(objName);
                }
                mbeanServer.registerMBean(this, objName);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("MBean registered " + objName));
                }
                success = true;
            }
            catch (Exception e) {
                LOG.error((Object)"Unable to register to mbean server", (Throwable)e);
            }
        }
        return success;
    }

    public boolean unregisterMbean(MBeanServer mbeanServer) {
        boolean success = false;
        if (null != mbeanServer) {
            try {
                ObjectName objName = this.generateObjectName();
                JmxUtil.unregisterMBeanSafely(mbeanServer, objName, LOG);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("MBean unregistered " + objName));
                }
                success = true;
            }
            catch (Exception e) {
                LOG.error((Object)"Unable to register to mbean server", (Throwable)e);
            }
        }
        return success;
    }

    public abstract ObjectName generateObjectName() throws MalformedObjectNameException;

    protected Hashtable<String, String> generateBaseMBeanProps() {
        Hashtable<String, String> mbeanProps = new Hashtable<String, String>(5);
        mbeanProps.put("type", this.getClass().getSimpleName());
        return mbeanProps;
    }
}

