/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.filter;

import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.data_model.PhysicalPartition;
import com.linkedin.databus2.core.filter.DbusFilter;

public class PhysicalPartitionDbusFilter
implements DbusFilter {
    private final DbusFilter _nestedFilter;
    private final PhysicalPartition _ppart;

    public PhysicalPartitionDbusFilter(PhysicalPartition ppart, DbusFilter nestedFilter) {
        this._ppart = ppart;
        this._nestedFilter = nestedFilter;
    }

    @Override
    public boolean allow(DbusEvent e) {
        boolean success = this._ppart.isAnyPartitionWildcard() || e.physicalPartitionId() == this._ppart.getId().intValue();
        success = success && (null == this._nestedFilter || this._nestedFilter.allow(e));
        return success;
    }

    public DbusFilter getNestedFilter() {
        return this._nestedFilter;
    }

    public PhysicalPartition getPhysicalPartition() {
        return this._ppart;
    }
}

