/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.filter;

import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.data_model.LogicalSourceId;
import com.linkedin.databus2.core.filter.DbusFilter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class LogicalSourceAndPartitionDbusFilter
implements DbusFilter {
    private final HashMap<Integer, LogicalPartitionDbusFilter> _sources = new HashMap();

    public LogicalSourceAndPartitionDbusFilter() {
    }

    public LogicalSourceAndPartitionDbusFilter(LogicalSourceId sourceCond) {
        this();
        this.addSourceCondition(sourceCond);
    }

    public LogicalSourceAndPartitionDbusFilter(Set<LogicalSourceId> sourceConds) {
        this();
        for (LogicalSourceId sourceCond : sourceConds) {
            this.addSourceCondition(sourceCond);
        }
    }

    public void addSourceCondition(LogicalSourceId sourceCond) {
        if (sourceCond.getSource().isWildcard()) {
            return;
        }
        Integer srcId = sourceCond.getSource().getId();
        LogicalPartitionDbusFilter sourceFilter = this._sources.get(srcId);
        if (null == sourceFilter) {
            sourceFilter = new LogicalPartitionDbusFilter(sourceCond);
            this._sources.put(srcId, sourceFilter);
        } else {
            sourceFilter.addPartitionCondition(sourceCond);
        }
    }

    @Override
    public boolean allow(DbusEvent e) {
        if (e.isControlMessage()) {
            return true;
        }
        Integer srcId = e.srcId();
        LogicalPartitionDbusFilter srcFilter = this._sources.get(srcId);
        if (null == srcFilter) {
            return false;
        }
        return srcFilter.allow(e);
    }

    public LogicalPartitionDbusFilter getSourceFilter(Integer sourceId) {
        return this._sources.get(sourceId);
    }

    public static class LogicalPartitionDbusFilter
    implements DbusFilter {
        private boolean _isAllPartitionsWildcard = false;
        private HashSet<Integer> _ids = new HashSet(8);

        public LogicalPartitionDbusFilter(LogicalSourceId initCond) {
            this.addPartitionCondition(initCond);
        }

        public void addPartitionCondition(LogicalSourceId partitionCond) {
            if (partitionCond.isAllPartitionsWildcard()) {
                this._isAllPartitionsWildcard = true;
            } else if (!this._isAllPartitionsWildcard) {
                this._ids.add(partitionCond.getId().intValue());
            }
        }

        @Override
        public boolean allow(DbusEvent e) {
            return this._isAllPartitionsWildcard || this._ids.contains(e.logicalPartitionId());
        }

        public boolean isAllPartitionsWildcard() {
            return this._isAllPartitionsWildcard;
        }

        public Set<Integer> getPartitionsMask() {
            return Collections.unmodifiableSet(this._ids);
        }
    }
}

