/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.filter;

import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.core.filter.KeyFilterConfig;
import org.codehaus.jackson.map.ObjectMapper;

public class KeyRangeFilterConfig
extends KeyFilterConfig {
    private long rangeSize;
    private KeyFilterConfig.IDConfig rangeIds;
    protected static ObjectMapper _mapper;

    public KeyRangeFilterConfig() {
    }

    public KeyRangeFilterConfig(StaticConfig config) {
        this.rangeSize = config.getSize();
        this.rangeIds = config.getIdConfig();
    }

    public long getRangeSize() {
        return this.rangeSize;
    }

    public void setRangeSize(long rangeSize) {
        this.rangeSize = rangeSize;
    }

    public KeyFilterConfig.IDConfig getRangeIds() {
        return this.rangeIds;
    }

    public void setRangeIds(KeyFilterConfig.IDConfig rangeIds) {
        this.rangeIds = rangeIds;
    }

    public String toString() {
        return "KeyRangeFilterConfig [rangeSize=" + this.rangeSize + ", rangeIds=" + this.rangeIds + "]";
    }

    public static class Config
    implements ConfigBuilder<StaticConfig> {
        private long size;
        private String partitions;

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public String getPartitions() {
            return this.partitions;
        }

        public void setPartitions(String partitions) {
            this.partitions = partitions;
        }

        @Override
        public StaticConfig build() throws InvalidConfigException {
            if (this.size <= 0L) {
                throw new InvalidConfigException("Range size (" + this.size + ") must be greater than 0");
            }
            StaticConfig sConf = null;
            try {
                sConf = new StaticConfig(this.size, KeyFilterConfig.IDConfig.fromString(this.partitions));
            }
            catch (Exception ex) {
                throw new InvalidConfigException(ex);
            }
            return sConf;
        }
    }

    public static class StaticConfig {
        private long size;
        private KeyFilterConfig.IDConfig idConfig;

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public KeyFilterConfig.IDConfig getIdConfig() {
            return this.idConfig;
        }

        public void setIdConfig(KeyFilterConfig.IDConfig idConfig) {
            this.idConfig = idConfig;
        }

        public StaticConfig(long size, KeyFilterConfig.IDConfig idConfig) throws InvalidConfigException {
            this.size = size;
            this.idConfig = idConfig;
        }

        public String toString() {
            return "KeyRangeFilterConfig.StaticConfig [size=" + this.size + ", idConfig=" + this.idConfig + "]";
        }
    }
}

