/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.filter;

import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.util.Range;
import com.linkedin.databus2.core.filter.DbusFilter;

public class KeyRangeFilter
implements DbusFilter {
    private Range keyRange;

    public KeyRangeFilter(long minKey, long maxKey) {
        this.keyRange = new Range(minKey, maxKey);
    }

    public KeyRangeFilter() {
    }

    @Override
    public boolean allow(DbusEvent e) {
        if (e.isKeyNumber()) {
            long eventKey = e.key();
            return this.keyRange.contains(eventKey);
        }
        try {
            long eventKey = Long.parseLong(new String(e.keyBytes()));
            return this.keyRange.contains(eventKey);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException(nfe);
        }
    }

    public Range getKeyRange() {
        return this.keyRange;
    }

    public void setKeyRange(Range keyRange) {
        this.keyRange = keyRange;
    }

    public String toString() {
        return "KeyRangeFilter [keyRange=" + this.keyRange + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KeyRangeFilter)) {
            return false;
        }
        KeyRangeFilter r = (KeyRangeFilter)obj;
        return this.keyRange != null && this.keyRange.equals(r.getKeyRange()) || this.keyRange == r.getKeyRange();
    }

    public int hashCode() {
        return null == this.keyRange ? 0 : this.keyRange.hashCode();
    }
}

