/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.filter;

import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.core.filter.KeyFilterConfig;
import java.util.ArrayList;

public class KeyModFilterConfig
extends KeyFilterConfig {
    private long numBuckets;
    private KeyFilterConfig.IDConfig buckets;

    public KeyModFilterConfig() {
    }

    public KeyModFilterConfig(StaticConfig config) {
        this.numBuckets = config.getNumBuckets();
        this.buckets = config.getIdConfig();
    }

    public long getNumBuckets() {
        return this.numBuckets;
    }

    public void setNumBuckets(long numBuckets) {
        this.numBuckets = numBuckets;
    }

    public KeyFilterConfig.IDConfig getBuckets() {
        return this.buckets;
    }

    public void setBuckets(KeyFilterConfig.IDConfig buckets) {
        this.buckets = buckets;
    }

    public String toString() {
        return "KeyModFilterConfig [numBuckets=" + this.numBuckets + ", buckets=" + this.buckets + "]";
    }

    public static class Config
    implements ConfigBuilder<StaticConfig> {
        private long numBuckets;
        private String buckets;

        public long getNumBuckets() {
            return this.numBuckets;
        }

        public void setNumBuckets(long numBuckets) {
            this.numBuckets = numBuckets;
        }

        public String getBuckets() {
            return this.buckets;
        }

        public void setBuckets(String buckets) {
            this.buckets = buckets;
        }

        @Override
        public StaticConfig build() throws InvalidConfigException {
            StaticConfig config = null;
            try {
                config = new StaticConfig(this.numBuckets, KeyFilterConfig.IDConfig.fromString(this.buckets));
            }
            catch (Exception ex) {
                throw new InvalidConfigException(ex);
            }
            return config;
        }
    }

    public static class StaticConfig {
        private long numBuckets;
        private KeyFilterConfig.IDConfig idConfig;

        public long getNumBuckets() {
            return this.numBuckets;
        }

        public void setNumBuckets(long numBuckets) {
            this.numBuckets = numBuckets;
        }

        public KeyFilterConfig.IDConfig getIdConfig() {
            return this.idConfig;
        }

        public void setIdConfig(KeyFilterConfig.IDConfig idConfig) {
            this.idConfig = idConfig;
        }

        public String toString() {
            return "StaticConfig [numBuckets=" + this.numBuckets + ", idConfig=" + this.idConfig + "]";
        }

        public StaticConfig(long numBuckets, KeyFilterConfig.IDConfig idConfig) throws InvalidConfigException {
            this.numBuckets = numBuckets;
            this.idConfig = idConfig;
            if (numBuckets <= 0L) {
                throw new InvalidConfigException("Mod Numbuckets (" + numBuckets + ") must be greater than 0");
            }
            ArrayList<KeyFilterConfig.IDConfigEntry> idConfigs = idConfig.getIdConfigs();
            for (KeyFilterConfig.IDConfigEntry entry : idConfigs) {
                if (entry.getIdMax() >= 0L && entry.getIdMin() >= 0L && entry.getIdMin() <= entry.getIdMax() && entry.getIdMin() <= numBuckets && entry.getIdMax() <= numBuckets) continue;
                throw new InvalidConfigException("Mod idConfig Entry (" + entry + ") is invalid for bucket size (" + numBuckets + ")");
            }
        }
    }
}

