/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.filter;

import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.util.Range;
import com.linkedin.databus2.core.filter.DbusFilter;

public class KeyModFilter
implements DbusFilter {
    private long numBuckets;
    private Range bktRange;

    public KeyModFilter(long minBucket, long maxBucket, long numBuckets) {
        this.numBuckets = numBuckets;
        this.bktRange = new Range(minBucket, maxBucket);
    }

    public KeyModFilter() {
    }

    @Override
    public boolean allow(DbusEvent e) {
        long key = -1L;
        if (e.isKeyNumber()) {
            key = e.key();
        } else {
            String str = new String(e.keyBytes());
            try {
                key = Long.parseLong(str);
            }
            catch (NumberFormatException nfe) {
                key = str.hashCode();
            }
        }
        long bktId = Math.abs(key) % this.numBuckets;
        return this.bktRange.contains(bktId);
    }

    public long getNumBuckets() {
        return this.numBuckets;
    }

    public void setNumBuckets(long numBuckets) {
        this.numBuckets = numBuckets;
    }

    public Range getBktRange() {
        return this.bktRange;
    }

    public void setBktRange(Range bktRange) {
        this.bktRange = bktRange;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KeyModFilter)) {
            return false;
        }
        KeyModFilter modF = (KeyModFilter)obj;
        return this.bktRange != null && this.bktRange.equals(modF.getBktRange()) || this.bktRange == modF.getBktRange() && this.numBuckets == modF.getNumBuckets();
    }

    public int hashCode() {
        return null == this.bktRange ? 0 : this.bktRange.hashCode();
    }
}

