/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.filter;

import com.linkedin.databus2.core.filter.DbusFilter;
import com.linkedin.databus2.core.filter.DbusKeyFilter;
import com.linkedin.databus2.core.filter.KeyFilterConfigHolder;
import com.linkedin.databus2.core.filter.KeyModFilter;
import com.linkedin.databus2.core.filter.KeyRangeFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class KeyFilterConfigJSONFactory {
    public static final String MODULE = KeyFilterConfigJSONFactory.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private static final String partitionTypeFieldName = "partitionType";
    private static final String filterConfigFieldName = "filters";

    public static DbusKeyFilter parseDbusKeyFilter(String s) throws JSONException, IOException {
        JSONObject obj = new JSONObject(s);
        ObjectMapper mapper = new ObjectMapper();
        return KeyFilterConfigJSONFactory.getDbusKeyFilter(obj, mapper);
    }

    private static DbusKeyFilter getDbusKeyFilter(JSONObject obj, ObjectMapper mapper) throws JSONException, IOException {
        String type = obj.getString(partitionTypeFieldName);
        JSONArray array = null;
        DbusKeyFilter configHolder = new DbusKeyFilter();
        configHolder.setPartitionType(KeyFilterConfigHolder.PartitionType.valueOf(type));
        if (!obj.has(filterConfigFieldName) || obj.isNull(filterConfigFieldName)) {
            return configHolder;
        }
        array = obj.getJSONArray(filterConfigFieldName);
        ArrayList<DbusFilter> filters = new ArrayList<DbusFilter>();
        for (int i = 0; i < array.length(); ++i) {
            filters.add(KeyFilterConfigJSONFactory.getDbusFilter(array.getString(i), configHolder.getPartitionType(), mapper));
        }
        configHolder.setFilters(filters);
        return configHolder;
    }

    private static DbusFilter getDbusFilter(String objStr, KeyFilterConfigHolder.PartitionType type, ObjectMapper objMapper) throws JSONException, IOException {
        DbusFilter filter = null;
        if (type == KeyFilterConfigHolder.PartitionType.MOD) {
            filter = (DbusFilter)objMapper.readValue(objStr, KeyModFilter.class);
        } else if (type == KeyFilterConfigHolder.PartitionType.RANGE) {
            filter = (DbusFilter)objMapper.readValue(objStr, KeyRangeFilter.class);
        }
        return filter;
    }

    public static Map<Long, DbusKeyFilter> parseSrcIdFilterConfigMap(String s) throws JSONException, IOException {
        HashMap<Long, DbusKeyFilter> filterConfigMap = new HashMap<Long, DbusKeyFilter>();
        HashMap<Long, JSONObject> genericMap = new HashMap<Long, JSONObject>();
        ObjectMapper mapper = new ObjectMapper();
        try {
            JSONObject obj2 = new JSONObject(s);
            Iterator itr = obj2.keys();
            while (itr.hasNext()) {
                String k = (String)itr.next();
                Long key = Long.valueOf(k);
                genericMap.put(key, obj2.getJSONObject(key.toString()));
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Got exception while parsing filterConfig", (Throwable)ex);
            throw new JSONException((Throwable)ex);
        }
        for (Map.Entry obj : genericMap.entrySet()) {
            filterConfigMap.put((Long)obj.getKey(), KeyFilterConfigJSONFactory.getDbusKeyFilter((JSONObject)obj.getValue(), mapper));
        }
        return filterConfigMap;
    }
}

