/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.filter;

import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.ConfigLoader;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.core.filter.KeyFilterConfig;
import com.linkedin.databus2.core.filter.KeyModFilterConfig;
import com.linkedin.databus2.core.filter.KeyRangeFilterConfig;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.json.JSONObject;

public class KeyFilterConfigHolder {
    public static final String MODULE = KeyFilterConfigHolder.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String NO_PARTITIONING = "NONE";
    public static final String RANGE_PARTITIONING = "RANGE";
    public static final String MOD_PARTITIONING = "MOD";
    public static final Long UPPER_END_UNLIMITED = Long.MAX_VALUE;
    private PartitionType partitionType;
    private KeyFilterConfig filterConfig;

    public KeyFilterConfigHolder(StaticConfig config) {
        this.partitionType = config.getType();
        this.filterConfig = config.getConfig();
    }

    public KeyFilterConfigHolder() {
    }

    public PartitionType getPartitionType() {
        return this.partitionType;
    }

    public void setPartitionType(PartitionType partitionType) {
        this.partitionType = partitionType;
    }

    public KeyFilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void setFilterConfig(KeyFilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public String toString() {
        return "KeyFilterConfigHolder [partitionType=" + (Object)((Object)this.partitionType) + ", filterConfig=" + this.filterConfig + "]";
    }

    public static void main(String[] args) throws Exception {
        Properties props = new Properties();
        props.setProperty("dummy.type", MOD_PARTITIONING);
        props.setProperty("dummy.mod.numBuckets", "10");
        props.setProperty("dummy.mod.buckets", "[1,2,4-7]");
        Config config = new Config();
        ConfigLoader<StaticConfig> configLoader = new ConfigLoader<StaticConfig>("dummy.", config);
        StaticConfig staticConfig = configLoader.loadConfig(props);
        KeyFilterConfigHolder holder = new KeyFilterConfigHolder(staticConfig);
        System.out.println("Holder is :" + holder.toString());
        ObjectMapper mapper = new ObjectMapper();
        String s = mapper.writeValueAsString((Object)holder);
        System.out.println("Config Holder JSON:" + s);
        JSONObject obj = new JSONObject(s);
        String type = obj.getString("partitionType");
        String configStr = obj.getString("filterConfig");
        KeyFilterConfigHolder configHolder = new KeyFilterConfigHolder();
        configHolder.setPartitionType(PartitionType.valueOf(type));
        KeyFilterConfig conf = null;
        if (PartitionType.MOD == configHolder.getPartitionType()) {
            conf = (KeyFilterConfig)mapper.readValue(configStr, KeyModFilterConfig.class);
        } else if (PartitionType.RANGE == configHolder.getPartitionType()) {
            conf = (KeyFilterConfig)mapper.readValue(configStr, KeyRangeFilterConfig.class);
        }
        configHolder.setFilterConfig(conf);
        System.out.println("Holder2 is :" + configHolder.toString());
    }

    public static class Config
    implements ConfigBuilder<StaticConfig> {
        private KeyRangeFilterConfig.Config range = new KeyRangeFilterConfig.Config();
        private KeyModFilterConfig.Config mod = new KeyModFilterConfig.Config();
        private String type;

        public KeyRangeFilterConfig.Config getRange() {
            return this.range;
        }

        public void setRange(KeyRangeFilterConfig.Config range) {
            this.range = range;
        }

        public KeyModFilterConfig.Config getMod() {
            return this.mod;
        }

        public void setMod(KeyModFilterConfig.Config mod) {
            this.mod = mod;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        @Override
        public StaticConfig build() throws InvalidConfigException {
            PartitionType pType = PartitionType.valueOf(this.type);
            KeyFilterConfig config = null;
            if (null == this.range.getPartitions() && pType == PartitionType.RANGE) {
                throw new InvalidConfigException("PartitionType is set to range but range configuration is not given.");
            }
            if (null == this.mod.getBuckets() && pType == PartitionType.MOD) {
                throw new InvalidConfigException("PartitionType is set to mod but mod configuration is not given.");
            }
            if (pType == PartitionType.RANGE) {
                config = new KeyRangeFilterConfig(this.range.build());
            } else if (pType == PartitionType.MOD) {
                config = new KeyModFilterConfig(this.mod.build());
            }
            return new StaticConfig(pType, config);
        }
    }

    public static class StaticConfig {
        private PartitionType type;
        private KeyFilterConfig config;

        public PartitionType getType() {
            return this.type;
        }

        public void setType(PartitionType type) {
            this.type = type;
        }

        public KeyFilterConfig getConfig() {
            return this.config;
        }

        public void setConfig(KeyFilterConfig config) {
            this.config = config;
        }

        public StaticConfig(PartitionType type, KeyFilterConfig config) {
            this.type = type;
            this.config = config;
        }
    }

    public static enum PartitionType {
        NONE,
        RANGE,
        MOD;

    }
}

