/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.filter;

import java.util.ArrayList;

public class KeyFilterConfig {

    public static class IDConfigEntry {
        public static final String RANGE_DELIMITER = "-";
        private long idMin;
        private long idMax;
        private Type type;

        public long getIdMin() {
            return this.idMin;
        }

        public void setIdMin(long idMin) {
            this.idMin = idMin;
        }

        public long getIdMax() {
            return this.idMax;
        }

        public void setIdMax(long idMax) {
            this.idMax = idMax;
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public static IDConfigEntry fromString(String entryStr) {
            IDConfigEntry idConf = new IDConfigEntry();
            String entry = entryStr.trim();
            if (entry.contains(RANGE_DELIMITER)) {
                idConf.setType(Type.RANGE);
                String[] vals = entry.split(RANGE_DELIMITER);
                long v1 = Long.parseLong(vals[0]);
                long v2 = Long.parseLong(vals[1]);
                idConf.setIdMin(v1);
                idConf.setIdMax(v2);
                if (v1 > v2) {
                    throw new RuntimeException("IDConfigEntry is invalid. idMin is greater than idMax. Entry :" + entry);
                }
            } else {
                idConf.setType(Type.SINGLE);
                long val = Long.parseLong(entry);
                idConf.setIdMin(val);
                idConf.setIdMax(val);
            }
            return idConf;
        }

        public String toString() {
            if (this.type == Type.RANGE) {
                return this.idMin + RANGE_DELIMITER + this.idMax;
            }
            return "" + this.idMin;
        }

        public boolean matches(long id) {
            if (this.type == Type.SINGLE) {
                return id == this.idMin;
            }
            return id >= this.idMin && id <= this.idMax;
        }

        public static enum Type {
            SINGLE,
            RANGE;

        }
    }

    public static class IDConfig {
        public static final String PREFIX = "[";
        public static final String DELIMITER = ",";
        public static final String SUFFIX = "]";
        public ArrayList<IDConfigEntry> idConfigs;

        public static IDConfig fromString(String entryStr) {
            String[] vals;
            if (null == entryStr) {
                return null;
            }
            String entry = entryStr.trim();
            if (!entry.startsWith(PREFIX) || !entry.endsWith(SUFFIX)) {
                throw new RuntimeException("IDConfig missing PREFIX/SUFFIX. Config should be of the format : [ <IDConfigEntry1>, <IDConfigEntry2> ...]");
            }
            ArrayList<IDConfigEntry> idConfigs = new ArrayList<IDConfigEntry>();
            for (String v : vals = entry.substring(1, entry.length() - 1).split(DELIMITER)) {
                idConfigs.add(IDConfigEntry.fromString(v));
            }
            IDConfig idConf = new IDConfig();
            idConf.setIdConfigs(idConfigs);
            return idConf;
        }

        public ArrayList<IDConfigEntry> getIdConfigs() {
            return this.idConfigs;
        }

        public void setIdConfigs(ArrayList<IDConfigEntry> idConfigs) {
            this.idConfigs = idConfigs;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append(PREFIX);
            boolean first = true;
            for (IDConfigEntry id : this.idConfigs) {
                if (!first) {
                    str.append(DELIMITER);
                }
                first = false;
                str.append(id.toString());
            }
            str.append(SUFFIX);
            return str.toString();
        }

        public boolean matches(long id) {
            boolean match = false;
            for (IDConfigEntry idConfig : this.idConfigs) {
                match = idConfig.matches(id);
                if (!match) continue;
                return true;
            }
            return false;
        }
    }
}

