/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.filter;

import com.linkedin.databus.core.util.Range;
import com.linkedin.databus2.core.filter.DbusFilter;
import com.linkedin.databus2.core.filter.KeyModFilter;
import com.linkedin.databus2.core.filter.KeyRangeFilter;
import org.apache.log4j.Logger;

public class FilterToSQL {
    public static final String MODULE = FilterToSQL.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String KEYCOLUMN = "srckey";
    private static final String EMPTY_STRING = "";

    public static String convertToSQL(DbusFilter filter) {
        if (filter instanceof KeyModFilter) {
            return FilterToSQL.convertKeyModFilter((KeyModFilter)filter);
        }
        if (filter instanceof KeyRangeFilter) {
            return FilterToSQL.convertKeyRangeFilter((KeyRangeFilter)filter);
        }
        LOG.error((Object)"Unimplemented FilterToSQL for this filter, cannot convert to SQL!");
        return EMPTY_STRING;
    }

    private static String convertKeyRangeFilter(KeyRangeFilter filter) {
        Range range = filter.getKeyRange();
        StringBuffer sql = new StringBuffer();
        sql.append("srckey >= ");
        sql.append(range.getStart());
        sql.append(" AND ");
        sql.append("srckey < ");
        sql.append(range.getEnd());
        return sql.toString();
    }

    private static String convertKeyModFilter(KeyModFilter filter) {
        long buckets = filter.getNumBuckets();
        Range range = filter.getBktRange();
        StringBuffer sql = new StringBuffer();
        sql.append("srckey%" + buckets + " >= ");
        sql.append(range.getStart());
        sql.append(" AND ");
        sql.append("srckey%" + buckets + " < ");
        sql.append(range.getEnd());
        return sql.toString();
    }
}

