/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.filter;

import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus2.core.filter.DbusFilter;
import com.linkedin.databus2.core.filter.KeyFilterConfig;
import com.linkedin.databus2.core.filter.KeyFilterConfigHolder;
import com.linkedin.databus2.core.filter.KeyModFilter;
import com.linkedin.databus2.core.filter.KeyModFilterConfig;
import com.linkedin.databus2.core.filter.KeyRangeFilter;
import com.linkedin.databus2.core.filter.KeyRangeFilterConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class DbusKeyFilter
implements DbusFilter {
    public static final String MODULE = DbusKeyFilter.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private static final Long UPPER_END_UNLIMITED = Long.MAX_VALUE;
    private KeyFilterConfigHolder.PartitionType partitionType;
    private ArrayList<DbusFilter> filters;

    public DbusKeyFilter(KeyFilterConfigHolder config) {
        this.partitionType = config.getPartitionType();
        this.init(config);
    }

    public DbusKeyFilter() {
        this.partitionType = KeyFilterConfigHolder.PartitionType.NONE;
        this.filters = new ArrayList();
    }

    public KeyFilterConfigHolder.PartitionType getPartitionType() {
        return this.partitionType;
    }

    public void setPartitionType(KeyFilterConfigHolder.PartitionType partitionType) {
        this.partitionType = partitionType;
    }

    public ArrayList<DbusFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(ArrayList<DbusFilter> filters) {
        this.filters = filters;
    }

    public String toString() {
        return "DbusKeyFilter [partitionType=" + (Object)((Object)this.partitionType) + ", filters=" + this.filters + "]";
    }

    private void init(KeyFilterConfigHolder config) {
        boolean debugEnabled = LOG.isDebugEnabled();
        if (KeyFilterConfigHolder.PartitionType.NONE == config.getPartitionType()) {
            this.filters = new ArrayList();
            return;
        }
        if (config.getPartitionType() == KeyFilterConfigHolder.PartitionType.RANGE) {
            this.filters = new ArrayList();
            KeyRangeFilterConfig filterConfig = (KeyRangeFilterConfig)config.getFilterConfig();
            long rangeSize = filterConfig.getRangeSize();
            ArrayList<KeyFilterConfig.IDConfigEntry> partList = filterConfig.getRangeIds().getIdConfigs();
            for (KeyFilterConfig.IDConfigEntry entry : partList) {
                long keyMin = entry.getIdMin() * rangeSize;
                long keyMax = 0L;
                keyMax = entry.getIdMax() == UPPER_END_UNLIMITED.longValue() ? Long.MAX_VALUE : (entry.getIdMax() + 1L) * rangeSize;
                if (debugEnabled) {
                    LOG.debug((Object)("KeyBasedFilter: keyMin is:" + keyMin + ", keyMax is :" + keyMax));
                }
                this.filters.add(new KeyRangeFilter(keyMin, keyMax));
            }
        } else {
            this.filters = new ArrayList();
            KeyModFilterConfig filterConfig = (KeyModFilterConfig)config.getFilterConfig();
            long numBuckets = filterConfig.getNumBuckets();
            if (numBuckets <= 0L) {
                throw new RuntimeException("NumBuckets for ModBasedFiltering should be positive. Config was :" + config);
            }
            ArrayList<KeyFilterConfig.IDConfigEntry> partList = filterConfig.getBuckets().getIdConfigs();
            for (KeyFilterConfig.IDConfigEntry entry : partList) {
                long bktMin = entry.getIdMin();
                long bktMax = 0L;
                bktMax = entry.getIdMax() == UPPER_END_UNLIMITED.longValue() ? Long.MAX_VALUE : entry.getIdMax() + 1L;
                if (debugEnabled) {
                    LOG.debug((Object)("ModBasedFilter: StartBucket is:" + bktMin + ", BktMax is :" + bktMax));
                }
                this.filters.add(new KeyModFilter(bktMin, bktMax, numBuckets));
            }
        }
    }

    @Override
    public boolean allow(DbusEvent e) {
        boolean allow = false;
        if (this.partitionType == KeyFilterConfigHolder.PartitionType.NONE) {
            allow = true;
        } else {
            DbusFilter filter;
            Iterator<DbusFilter> i$ = this.filters.iterator();
            while (i$.hasNext() && !(allow = (filter = i$.next()).allow(e))) {
            }
        }
        return allow;
    }

    public void merge(DbusKeyFilter filter) {
        if (filter.getPartitionType() != KeyFilterConfigHolder.PartitionType.NONE && this.partitionType != KeyFilterConfigHolder.PartitionType.NONE && this.partitionType != filter.getPartitionType()) {
            String msg = "Partition Type not same in merge. this.filter is :" + this.toString() + ", Merging Filter is :" + filter;
            LOG.error((Object)msg);
            throw new RuntimeException(msg);
        }
        if (null == this.filters) {
            this.filters = new ArrayList();
        }
        this.filters.addAll(filter.getFilters());
    }

    public void dedupe() {
        ArrayList<DbusFilter> dedupFilters = new ArrayList<DbusFilter>();
        HashSet<DbusFilter> filterSet = new HashSet<DbusFilter>();
        for (DbusFilter f : this.filters) {
            filterSet.add(f);
        }
        for (DbusFilter f : filterSet) {
            dedupFilters.add(f);
        }
        this.filters = dedupFilters;
    }
}

