/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.filter;

import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.ConfigLoader;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.core.filter.KeyFilterConfigHolder;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DbusKeyCompositeFilterConfig {
    public static final String MODULE = DbusKeyCompositeFilterConfig.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private Map<String, KeyFilterConfigHolder> configMap;

    public DbusKeyCompositeFilterConfig() {
        this.configMap = new HashMap<String, KeyFilterConfigHolder>();
    }

    public DbusKeyCompositeFilterConfig(StaticConfig conf) {
        this.configMap = conf.getConfigMap();
    }

    public Map<String, KeyFilterConfigHolder> getConfigMap() {
        return this.configMap;
    }

    public void setConfigMap(Map<String, KeyFilterConfigHolder> configMap) {
        this.configMap = configMap;
    }

    public void addFilterConfig(String srcName, KeyFilterConfigHolder config) {
        this.configMap.put(srcName, config);
    }

    public String toString() {
        return "DbusKeyCompositeFilterConfig [configMap=" + this.configMap + "]";
    }

    public static void main(String[] args) throws Exception {
        String configFile = "/Users/bvaradar/Documents/workspace/BR_DDS_SERVER_SIDE_FILTERING/integration-test/config/server-filter-test.properties";
        Properties startupProps = new Properties();
        startupProps.load(new FileInputStream(configFile));
        Config staticConfigBuilder = new Config();
        ConfigLoader<StaticConfig> staticConfigLoader = new ConfigLoader<StaticConfig>("serversidefilter.", staticConfigBuilder);
        StaticConfig staticConfig = staticConfigLoader.loadConfig(startupProps);
        DbusKeyCompositeFilterConfig filterConf = new DbusKeyCompositeFilterConfig(staticConfig);
        System.out.println("FilterConf :" + filterConf);
    }

    public static class Config
    implements ConfigBuilder<StaticConfig> {
        private Map<String, KeyFilterConfigHolder.Config> _filterMap = new HashMap<String, KeyFilterConfigHolder.Config>();

        public void setFilter(String key, KeyFilterConfigHolder.Config conf) {
            this._filterMap.put(key, conf);
        }

        public KeyFilterConfigHolder.Config getFilter(String key) {
            KeyFilterConfigHolder.Config conf = this._filterMap.get(key);
            if (null == conf) {
                conf = new KeyFilterConfigHolder.Config();
                this._filterMap.put(key, conf);
            }
            return conf;
        }

        @Override
        public StaticConfig build() throws InvalidConfigException {
            HashMap<String, KeyFilterConfigHolder> confMap = new HashMap<String, KeyFilterConfigHolder>();
            for (Map.Entry<String, KeyFilterConfigHolder.Config> e : this._filterMap.entrySet()) {
                KeyFilterConfigHolder f = new KeyFilterConfigHolder(e.getValue().build());
                confMap.put(e.getKey(), f);
            }
            LOG.info((Object)("FilterConfigMap is:" + confMap));
            return new StaticConfig(confMap);
        }
    }

    public static class StaticConfig {
        private final Map<String, KeyFilterConfigHolder> configMap;

        public Map<String, KeyFilterConfigHolder> getConfigMap() {
            return this.configMap;
        }

        public StaticConfig(Map<String, KeyFilterConfigHolder> configMap) {
            this.configMap = configMap;
        }
    }
}

