/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.filter;

import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusEventInternalReadable;
import com.linkedin.databus2.core.filter.DbusFilter;
import com.linkedin.databus2.core.filter.DbusKeyFilter;
import com.linkedin.databus2.core.filter.KeyFilterConfigHolder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DbusKeyCompositeFilter
implements DbusFilter {
    public static final String MODULE = DbusKeyCompositeFilter.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private Map<Long, DbusKeyFilter> filterMap = new HashMap<Long, DbusKeyFilter>();

    public DbusKeyCompositeFilter(Map<Long, KeyFilterConfigHolder> configMap) {
        for (Map.Entry<Long, KeyFilterConfigHolder> entry : configMap.entrySet()) {
            this.filterMap.put(entry.getKey(), new DbusKeyFilter(entry.getValue()));
        }
    }

    public DbusKeyCompositeFilter() {
    }

    public String toString() {
        return "DbusKeyCompositeFilter [filterMap=" + this.filterMap + "]";
    }

    public Map<Long, DbusKeyFilter> getFilterMap() {
        return this.filterMap;
    }

    public void setFilterMap(Map<Long, DbusKeyFilter> filterMap) {
        this.filterMap = filterMap;
    }

    @Override
    public boolean allow(DbusEvent e) {
        long srcId = e.srcId();
        DbusKeyFilter filter = this.filterMap.get(srcId);
        if (null != filter) {
            boolean allow = filter.allow(e);
            if (LOG.isDebugEnabled() && e instanceof DbusEventInternalReadable) {
                LOG.debug((Object)("Filtered Response was :" + allow + " for key :" + ((DbusEventInternalReadable)e).getDbusEventKey()));
            }
            return allow;
        }
        return true;
    }

    public void merge(DbusKeyCompositeFilter filter) {
        Set<Map.Entry<Long, DbusKeyFilter>> entries = filter.getFilterMap().entrySet();
        for (Map.Entry<Long, DbusKeyFilter> e : entries) {
            DbusKeyFilter f1 = e.getValue();
            DbusKeyFilter f2 = this.filterMap.get(e.getKey());
            if (null == f2) {
                this.filterMap.put(e.getKey(), f1);
                continue;
            }
            f2.merge(f1);
            this.filterMap.put(e.getKey(), f2);
        }
    }

    public void dedupe() {
        Set<Map.Entry<Long, DbusKeyFilter>> entries = this.filterMap.entrySet();
        for (Map.Entry<Long, DbusKeyFilter> e : entries) {
            DbusKeyFilter f = e.getValue();
            if (null == f) continue;
            f.dedupe();
        }
    }
}

