/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core;

import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.core.BackoffTimerStaticConfig;

public class BackoffTimerStaticConfigBuilder
implements ConfigBuilder<BackoffTimerStaticConfig> {
    public static final long NO_SLEEP = 0L;
    private long _initSleep = 0L;
    private long _maxSleep = 60000L;
    private double _sleepIncFactor = 2.0;
    private long _sleepIncDelta = 1L;
    private int _maxRetryNum = 10;

    public long getInitSleep() {
        return this._initSleep;
    }

    public void setInitSleep(long initSleep) {
        this._initSleep = initSleep;
    }

    public long getMaxSleep() {
        return this._maxSleep;
    }

    public void setMaxSleep(long maxSleep) {
        this._maxSleep = maxSleep;
    }

    public double getSleepIncFactor() {
        return this._sleepIncFactor;
    }

    public void setSleepIncFactor(double sleepIncFactor) {
        this._sleepIncFactor = sleepIncFactor;
    }

    public long getSleepIncDelta() {
        return this._sleepIncDelta;
    }

    public void setSleepIncDelta(long sleepIncDelta) {
        this._sleepIncDelta = sleepIncDelta;
    }

    public int getMaxRetryNum() {
        return this._maxRetryNum;
    }

    public void setMaxRetryNum(int maxRetryNum) {
        this._maxRetryNum = maxRetryNum;
    }

    @Override
    public BackoffTimerStaticConfig build() throws InvalidConfigException {
        if (0L > this._initSleep) {
            throw new InvalidConfigException("initial sleep must be non-negative:" + this._initSleep);
        }
        if (0L > this._maxSleep) {
            throw new InvalidConfigException("max sleep must be non-negative: " + this._maxSleep);
        }
        BackoffTimerStaticConfig newConfig = new BackoffTimerStaticConfig(this._initSleep, this._maxSleep, this._sleepIncFactor, this._sleepIncDelta, this._maxRetryNum);
        long secondSleep = newConfig.calcNextSleep(this._initSleep);
        if (secondSleep < this._initSleep || secondSleep < 0L) {
            throw new InvalidConfigException("sleeps are decreasing!");
        }
        return newConfig;
    }

    public String toString() {
        return "BackoffTimerStaticConfigBuilder [_initSleep=" + this._initSleep + ", _maxSleep=" + this._maxSleep + ", _sleepIncFactor=" + this._sleepIncFactor + ", _sleepIncDelta=" + this._sleepIncDelta + ", _maxRetryNum=" + this._maxRetryNum + "]";
    }
}

