/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core;

public class BackoffTimerStaticConfig {
    public static final BackoffTimerStaticConfig NO_RETRIES = new BackoffTimerStaticConfig(0L, 0L, 0.0, 0L, 0);
    public static final BackoffTimerStaticConfig UNLIMITED_RETRIES = new BackoffTimerStaticConfig(0L, 0L, 0.0, 0L, -1);
    private final long _initSleep;
    private final long _maxSleep;
    private final double _sleepIncFactor;
    private final long _sleepIncDelta;
    private final int _maxRetryNum;

    public BackoffTimerStaticConfig(long initSleep, long maxSleep, double sleepIncFactor, long sleepIncDelta, int maxRetryNum) {
        this._initSleep = initSleep;
        this._maxSleep = maxSleep;
        this._sleepIncFactor = sleepIncFactor;
        this._sleepIncDelta = sleepIncDelta;
        this._maxRetryNum = maxRetryNum;
    }

    public long getInitSleep() {
        return this._initSleep;
    }

    public long getMaxSleep() {
        return this._maxSleep;
    }

    public double getSleepIncFactor() {
        return this._sleepIncFactor;
    }

    public long getSleepIncDelta() {
        return this._sleepIncDelta;
    }

    public int getMaxRetryNum() {
        return this._maxRetryNum;
    }

    public long calcNextSleep(long curSleep) {
        if (curSleep < 0L) {
            return this._initSleep;
        }
        long newSleep = (long)(this._sleepIncFactor * (double)curSleep) + this._sleepIncDelta;
        if (newSleep <= curSleep) {
            newSleep = curSleep + 1L;
        }
        return Math.min(this._maxSleep, newSleep);
    }

    public String toString() {
        return "BackoffTimerStaticConfig [_initSleep=" + this._initSleep + ", _maxSleep=" + this._maxSleep + ", _sleepIncFactor=" + this._sleepIncFactor + ", _sleepIncDelta=" + this._sleepIncDelta + ", _maxRetryNum=" + this._maxRetryNum + "]";
    }
}

