/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core;

import com.linkedin.databus2.core.BackoffTimerStaticConfig;
import com.linkedin.databus2.core.BackoffTimerStaticConfigBuilder;
import org.apache.log4j.Logger;

public class BackoffTimer {
    public static final String MODULE = BackoffTimerStaticConfigBuilder.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final long NO_MORE_RETRIES = -1L;
    private final BackoffTimerStaticConfig _config;
    private final String _name;
    private long _retrySleepMs;
    private int _retriesNum;
    private long _retryStartTs;

    public BackoffTimer(String name, BackoffTimerStaticConfig config) {
        this._config = config;
        this._name = name;
        this.reset();
    }

    public BackoffTimerStaticConfig getConfig() {
        return this._config;
    }

    public long getCurrentSleepMs() {
        return this._retrySleepMs;
    }

    public int getRetriesNum() {
        return this._retriesNum;
    }

    public int getRemainingRetriesNum() {
        return this._config.getMaxRetryNum() >= 0 ? this._config.getMaxRetryNum() - this._retriesNum : Integer.MAX_VALUE;
    }

    public long getTotalRetryTime() {
        return this._retryStartTs > 0L ? System.currentTimeMillis() - this._retryStartTs : 0L;
    }

    public void reset() {
        this._retrySleepMs = this._config.getInitSleep();
        this._retriesNum = 0;
        this._retryStartTs = -1L;
    }

    public long backoff() {
        if (0 == this._retriesNum) {
            this._retryStartTs = System.currentTimeMillis();
        }
        ++this._retriesNum;
        this._retrySleepMs = this._config.calcNextSleep(this._retrySleepMs);
        if (this._config.getMaxRetryNum() >= 0 && this._retriesNum > this._config.getMaxRetryNum()) {
            return -1L;
        }
        return this._retrySleepMs;
    }

    public boolean sleep() {
        if (0L >= this._retrySleepMs) {
            return true;
        }
        boolean debugLogEnabled = LOG.isDebugEnabled();
        try {
            if (this._retriesNum > 0) {
                LOG.info((Object)(this._name + ": error sleep, ms: " + this._retrySleepMs));
            } else if (debugLogEnabled) {
                LOG.debug((Object)(this._name + ": sleeping for " + this._retrySleepMs));
            }
            Thread.sleep(this._retrySleepMs);
            return true;
        }
        catch (InterruptedException ex) {
            LOG.info((Object)(this._name + ": sleep interrupted"));
            return false;
        }
    }

    public boolean backoffAndSleep() {
        this.backoff();
        return this.sleep();
    }

    public String toString() {
        return "BackoffTimer [_config=" + this._config + ", _name=" + this._name + ", _retrySleepMs=" + this._retrySleepMs + ", _retriesNum=" + this._retriesNum + ", _retryStartTs=" + this._retryStartTs + "]";
    }
}

