/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core;

public enum AssertLevel {
    NONE(0),
    QUICK(100),
    MEDIUM(200),
    ALL(300);

    private final int _intValue;

    private AssertLevel(int intValue) {
        this._intValue = intValue;
    }

    public int getIntValue() {
        return this._intValue;
    }

    public boolean isSameOrStricter(AssertLevel other) {
        return this._intValue >= other._intValue;
    }

    public boolean enabled() {
        return this._intValue > AssertLevel.NONE._intValue;
    }

    public boolean quickEnabled() {
        return this.isSameOrStricter(QUICK);
    }

    public boolean mediumEnabled() {
        return this.isSameOrStricter(MEDIUM);
    }

    public boolean allEnabled() {
        return this.isSameOrStricter(ALL);
    }
}

