/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.math.BigInteger;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashSet;
import java.util.Set;

public class Utils {
    private static final Set<Integer> _assignedPorts = new HashSet<Integer>();

    public static long getUnsignedInt(ByteBuffer buffer, int index) {
        return (long)buffer.getInt(index) & 0xFFFFFFFFL;
    }

    public static void putUnsignedInt(ByteBuffer buffer, int index, long value) {
        buffer.putInt(index, (int)(value & 0xFFFFFFFFL));
    }

    public static String byteBufferToString(ByteBuffer buffer, String encoding) throws UnsupportedEncodingException {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return new String(bytes, encoding);
    }

    public static String byteBufferToString(ByteBuffer buffer) {
        return new String(Utils.byteBufferToBytes(buffer));
    }

    public static byte[] byteBufferToBytes(ByteBuffer buffer) {
        byte[] bytes = null;
        if (buffer.hasArray()) {
            bytes = buffer.array();
        } else {
            bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
        }
        return bytes;
    }

    public static FileChannel openChannel(File file, boolean mutable) throws FileNotFoundException {
        if (mutable) {
            return new RandomAccessFile(file, "rw").getChannel();
        }
        return new FileInputStream(file).getChannel();
    }

    public static BigInteger ipToBigInt(InetSocketAddress ipAddr) {
        int BYTES_IN_INTEGER = 4;
        byte[] addrBytes = ipAddr.getAddress().getAddress();
        int port = ipAddr.getPort();
        byte[] addrPlusPortBytes = new byte[addrBytes.length + 4];
        ByteBuffer destBuf = ByteBuffer.wrap(addrPlusPortBytes);
        destBuf.put(addrBytes);
        destBuf.putInt(port);
        BigInteger bigInt = new BigInteger(destBuf.array());
        return bigInt;
    }

    public static synchronized int getAvailablePort(int startPort) {
        int port;
        for (port = startPort; _assignedPorts.contains(port) && !Utils.portAvailable(port) && port < Integer.MAX_VALUE; ++port) {
        }
        if (Integer.MAX_VALUE == port) {
            throw new RuntimeException("no available port found starting at " + startPort);
        }
        _assignedPorts.add(port);
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean portAvailable(int port) {
        if (port < 1200 || port > 65000) {
            throw new IllegalArgumentException("Invalid start port: " + port);
        }
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }

    public static String getPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String[] values = name.split("@");
        String pid = values[0];
        return pid;
    }
}

