/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.util;

import org.apache.log4j.Logger;

public class UncaughtExceptionTrackingThread
extends Thread
implements Thread.UncaughtExceptionHandler {
    public static final Logger LOG = Logger.getLogger(UncaughtExceptionTrackingThread.class);
    private Throwable _lastException = null;

    public UncaughtExceptionTrackingThread() {
        this.setUncaughtExceptionHandler(this);
    }

    public UncaughtExceptionTrackingThread(Runnable target, String name) {
        super(target, name);
        this.setUncaughtExceptionHandler(this);
    }

    public UncaughtExceptionTrackingThread(Runnable target) {
        super(target);
        this.setUncaughtExceptionHandler(this);
    }

    public UncaughtExceptionTrackingThread(String name) {
        super(name);
        this.setUncaughtExceptionHandler(this);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this._lastException = e;
        LOG.error((Object)("uncaught exception in thread " + this.getName() + ": " + e.getMessage()), e);
    }

    public Throwable getLastException() {
        return this._lastException;
    }
}

