/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;

public class StringUtils {
    private static final Pattern ORA_JDBC_URI_PATTERN = Pattern.compile("(jdbc:oracle:thin:)([^/@]*)(/[^@]*)(@.*)");
    private static final Pattern MYSQL_JDBC_PATTERN1 = Pattern.compile("\\((user=|password=)([^)]*)\\)");
    private static final Pattern MYSQL_JDBC_PATTERN2 = Pattern.compile("(user=|password=)([^&]*)");
    public static final String DEFAULT_ENCODING_NAME = "UTF-8";
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    public static String bytesToString(byte[] bytes) {
        return new String(bytes, DEFAULT_CHARSET);
    }

    public static Reader createFileReader(File file) throws FileNotFoundException {
        return new InputStreamReader((InputStream)new FileInputStream(file), DEFAULT_CHARSET);
    }

    public static Reader createFileReader(String fileName) throws FileNotFoundException {
        return new InputStreamReader((InputStream)new FileInputStream(fileName), DEFAULT_CHARSET);
    }

    public static Writer createFileWriter(File file) throws FileNotFoundException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(file), DEFAULT_CHARSET);
    }

    public static Writer createFileWriter(String fileName) throws FileNotFoundException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), DEFAULT_CHARSET);
    }

    public static String hexdumpByteBufferContents(ByteBuffer buf, int bufOfs, int length) {
        if (length < 0) {
            return "";
        }
        int endOfs = Math.min(buf.limit(), bufOfs + length + 1);
        byte[] bytes = new byte[endOfs - bufOfs];
        buf = buf.duplicate();
        buf.position(bufOfs);
        buf.get(bytes);
        return new String(Hex.encodeHex((byte[])bytes));
    }

    public static String sanitizeDbUri(String uri) {
        String result = uri;
        Matcher m = ORA_JDBC_URI_PATTERN.matcher(uri);
        if (m.matches()) {
            result = m.group(1) + "*/*" + m.group(4);
        } else if (uri.startsWith("jdbc:mysql:")) {
            Matcher m1 = MYSQL_JDBC_PATTERN1.matcher(result);
            Matcher m2 = MYSQL_JDBC_PATTERN2.matcher(result);
            if (m1.find()) {
                result = m1.replaceAll("($1*)");
            } else if (m2.find()) {
                result = m2.replaceAll("$1*");
            }
        }
        return result;
    }
}

